# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PermissionAssignmentArgs', 'PermissionAssignment']

@pulumi.input_type
class PermissionAssignmentArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 principal_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a PermissionAssignment resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class _PermissionAssignmentState:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PermissionAssignment resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


class PermissionAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        These resources are invoked in the workspace context.

        ## Example Usage

        In workspace context, adding account-level user to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        me = databricks.get_user(user_name="me@example.com")
        add_user = databricks.PermissionAssignment("add_user",
            principal_id=me.id,
            permissions=["USER"])
        ```

        In workspace context, adding account-level service principal to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        sp = databricks.get_service_principal(display_name="Automation-only SP")
        add_admin_spn = databricks.PermissionAssignment("add_admin_spn",
            principal_id=sp.id,
            permissions=["ADMIN"])
        ```

        In workspace context, adding account-level group to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        account_level = databricks.get_group(display_name="example-group")
        # Use the workspace provider
        this = databricks.PermissionAssignment("this",
            principal_id=account_level.id,
            permissions=["USER"])
        workspace_level = databricks.get_group(display_name="example-group")
        pulumi.export("databricksGroupId", workspace_level.id)
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * MwsPermissionAssignment to manage permission assignment from an account context

        ## Import

        The resource `databricks_permission_assignment` can be imported using the principal id

        bash

        ```sh
        $ pulumi import databricks:index/permissionAssignment:PermissionAssignment this principal_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        These resources are invoked in the workspace context.

        ## Example Usage

        In workspace context, adding account-level user to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        me = databricks.get_user(user_name="me@example.com")
        add_user = databricks.PermissionAssignment("add_user",
            principal_id=me.id,
            permissions=["USER"])
        ```

        In workspace context, adding account-level service principal to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        sp = databricks.get_service_principal(display_name="Automation-only SP")
        add_admin_spn = databricks.PermissionAssignment("add_admin_spn",
            principal_id=sp.id,
            permissions=["ADMIN"])
        ```

        In workspace context, adding account-level group to a workspace:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # Use the account provider
        account_level = databricks.get_group(display_name="example-group")
        # Use the workspace provider
        this = databricks.PermissionAssignment("this",
            principal_id=account_level.id,
            permissions=["USER"])
        workspace_level = databricks.get_group(display_name="example-group")
        pulumi.export("databricksGroupId", workspace_level.id)
        ```

        ## Related Resources

        The following resources are used in the same context:

        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * MwsPermissionAssignment to manage permission assignment from an account context

        ## Import

        The resource `databricks_permission_assignment` can be imported using the principal id

        bash

        ```sh
        $ pulumi import databricks:index/permissionAssignment:PermissionAssignment this principal_id
        ```

        :param str resource_name: The name of the resource.
        :param PermissionAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionAssignmentArgs.__new__(PermissionAssignmentArgs)

            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
        super(PermissionAssignment, __self__).__init__(
            'databricks:index/permissionAssignment:PermissionAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            principal_id: Optional[pulumi.Input[str]] = None) -> 'PermissionAssignment':
        """
        Get an existing PermissionAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The list of workspace permissions to assign to the principal:
               * `"USER"` - Can access the workspace with basic privileges.
               * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        :param pulumi.Input[str] principal_id: Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionAssignmentState.__new__(_PermissionAssignmentState)

        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["principal_id"] = principal_id
        return PermissionAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of workspace permissions to assign to the principal:
        * `"USER"` - Can access the workspace with basic privileges.
        * `"ADMIN"` - Can access the workspace and has workspace admin privileges to manage users and groups, workspace configurations, and more.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[str]:
        """
        Databricks ID of the user, service principal, or group. The principal ID can be retrieved using the account-level SCIM API, or using databricks_user, ServicePrincipal or Group data sources with account API (and has to be an account admin). A more sensible approach is to retrieve the list of `principal_id` as outputs from another Pulumi stack.
        """
        return pulumi.get(self, "principal_id")

