# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecipientArgs', 'Recipient']

@pulumi.input_type
class RecipientArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 ip_access_list: Optional[pulumi.Input['RecipientIpAccessListArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 properties_kvpairs: Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]] = None):
        """
        The set of arguments for constructing a Recipient resource.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when `authentication_type` is `DATABRICKS`.
        :param pulumi.Input[int] expiration_time: Expiration timestamp of the token in epoch milliseconds.
        :param pulumi.Input['RecipientIpAccessListArgs'] ip_access_list: Recipient IP access list.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] owner: Username/groupname/sp application_id of the recipient owner.
        :param pulumi.Input['RecipientPropertiesKvpairsArgs'] properties_kvpairs: Recipient properties - object consisting of following fields:
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]] tokens: List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_recipient_global_metastore_id is not None:
            pulumi.set(__self__, "data_recipient_global_metastore_id", data_recipient_global_metastore_id)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if ip_access_list is not None:
            pulumi.set(__self__, "ip_access_list", ip_access_list)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties_kvpairs is not None:
            pulumi.set(__self__, "properties_kvpairs", properties_kvpairs)
        if sharing_code is not None:
            pulumi.set(__self__, "sharing_code", sharing_code)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `authentication_type` is `DATABRICKS`.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @data_recipient_global_metastore_id.setter
    def data_recipient_global_metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_recipient_global_metastore_id", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[int]]:
        """
        Expiration timestamp of the token in epoch milliseconds.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> Optional[pulumi.Input['RecipientIpAccessListArgs']]:
        """
        Recipient IP access list.
        """
        return pulumi.get(self, "ip_access_list")

    @ip_access_list.setter
    def ip_access_list(self, value: Optional[pulumi.Input['RecipientIpAccessListArgs']]):
        pulumi.set(self, "ip_access_list", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Username/groupname/sp application_id of the recipient owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="propertiesKvpairs")
    def properties_kvpairs(self) -> Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']]:
        """
        Recipient properties - object consisting of following fields:
        """
        return pulumi.get(self, "properties_kvpairs")

    @properties_kvpairs.setter
    def properties_kvpairs(self, value: Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']]):
        pulumi.set(self, "properties_kvpairs", value)

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> Optional[pulumi.Input[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @sharing_code.setter
    def sharing_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharing_code", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]:
        """
        List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]):
        pulumi.set(self, "tokens", value)


@pulumi.input_type
class _RecipientState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[bool]] = None,
                 activation_url: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[int]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 ip_access_list: Optional[pulumi.Input['RecipientIpAccessListArgs']] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 properties_kvpairs: Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[int]] = None,
                 updated_by: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Recipient resources.
        :param pulumi.Input[str] activation_url: Full activation URL to retrieve the access token. It will be empty if the token is already retrieved.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] cloud: Cloud vendor of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[int] created_at: Time at which this recipient was created, in epoch milliseconds.
        :param pulumi.Input[str] created_by: Username of recipient creator.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when `authentication_type` is `DATABRICKS`.
        :param pulumi.Input[int] expiration_time: Expiration timestamp of the token in epoch milliseconds.
        :param pulumi.Input['RecipientIpAccessListArgs'] ip_access_list: Recipient IP access list.
        :param pulumi.Input[str] metastore_id: Unique identifier of recipient's Unity Catalog metastore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] owner: Username/groupname/sp application_id of the recipient owner.
        :param pulumi.Input['RecipientPropertiesKvpairsArgs'] properties_kvpairs: Recipient properties - object consisting of following fields:
        :param pulumi.Input[str] region: Cloud region of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]] tokens: List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        :param pulumi.Input[int] updated_at: Time at which this recipient was updated, in epoch milliseconds.
        :param pulumi.Input[str] updated_by: Username of recipient Token updater.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if activation_url is not None:
            pulumi.set(__self__, "activation_url", activation_url)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if data_recipient_global_metastore_id is not None:
            pulumi.set(__self__, "data_recipient_global_metastore_id", data_recipient_global_metastore_id)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if ip_access_list is not None:
            pulumi.set(__self__, "ip_access_list", ip_access_list)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties_kvpairs is not None:
            pulumi.set(__self__, "properties_kvpairs", properties_kvpairs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sharing_code is not None:
            pulumi.set(__self__, "sharing_code", sharing_code)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="activationUrl")
    def activation_url(self) -> Optional[pulumi.Input[str]]:
        """
        Full activation URL to retrieve the access token. It will be empty if the token is already retrieved.
        """
        return pulumi.get(self, "activation_url")

    @activation_url.setter
    def activation_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_url", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud vendor of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[int]]:
        """
        Time at which this recipient was created, in epoch milliseconds.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Username of recipient creator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `authentication_type` is `DATABRICKS`.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @data_recipient_global_metastore_id.setter
    def data_recipient_global_metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_recipient_global_metastore_id", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[int]]:
        """
        Expiration timestamp of the token in epoch milliseconds.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> Optional[pulumi.Input['RecipientIpAccessListArgs']]:
        """
        Recipient IP access list.
        """
        return pulumi.get(self, "ip_access_list")

    @ip_access_list.setter
    def ip_access_list(self, value: Optional[pulumi.Input['RecipientIpAccessListArgs']]):
        pulumi.set(self, "ip_access_list", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of recipient's Unity Catalog metastore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Username/groupname/sp application_id of the recipient owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="propertiesKvpairs")
    def properties_kvpairs(self) -> Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']]:
        """
        Recipient properties - object consisting of following fields:
        """
        return pulumi.get(self, "properties_kvpairs")

    @properties_kvpairs.setter
    def properties_kvpairs(self, value: Optional[pulumi.Input['RecipientPropertiesKvpairsArgs']]):
        pulumi.set(self, "properties_kvpairs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud region of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> Optional[pulumi.Input[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @sharing_code.setter
    def sharing_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharing_code", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]:
        """
        List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]):
        pulumi.set(self, "tokens", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[int]]:
        """
        Time at which this recipient was updated, in epoch milliseconds.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[str]]:
        """
        Username of recipient Token updater.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_by", value)


class Recipient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 ip_access_list: Optional[pulumi.Input[Union['RecipientIpAccessListArgs', 'RecipientIpAccessListArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 properties_kvpairs: Optional[pulumi.Input[Union['RecipientPropertiesKvpairsArgs', 'RecipientPropertiesKvpairsArgsDict']]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecipientTokenArgs', 'RecipientTokenArgsDict']]]]] = None,
                 __props__=None):
        """
        > This resource can only be used with a workspace-level provider!

        In Delta Sharing, a recipient is an entity that receives shares from a provider. In Unity Catalog, a share is a securable object that represents an organization and associates it with a credential or secure sharing identifier that allows that organization to access one or more shares.

        As a data provider (sharer), you can define multiple recipients for any given Unity Catalog metastore, but if you want to share data from multiple metastores with a particular user or group of users, you must define the recipient separately for each metastore. A recipient can have access to multiple shares.

        A `Recipient` is contained within Metastore and can have permissions to `SELECT` from a list of shares.

        ## Example Usage

        ### Databricks Sharing with non databricks recipient

        Setting `authentication_type` type to `TOKEN` creates a temporary url to download a credentials file. This is used to
        authenticate to the sharing server to access data. This is for when the recipient is not using Databricks.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_random as random

        db2opensharecode = random.index.Password("db2opensharecode",
            length=16,
            special=True)
        current = databricks.get_current_user()
        db2open = databricks.Recipient("db2open",
            name=f"{current.alphanumeric}-recipient",
            comment="Made by Pulumi",
            authentication_type="TOKEN",
            sharing_code=db2opensharecode["result"],
            ip_access_list={
                "allowed_ip_addresses": [],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when `authentication_type` is `DATABRICKS`.
        :param pulumi.Input[int] expiration_time: Expiration timestamp of the token in epoch milliseconds.
        :param pulumi.Input[Union['RecipientIpAccessListArgs', 'RecipientIpAccessListArgsDict']] ip_access_list: Recipient IP access list.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] owner: Username/groupname/sp application_id of the recipient owner.
        :param pulumi.Input[Union['RecipientPropertiesKvpairsArgs', 'RecipientPropertiesKvpairsArgsDict']] properties_kvpairs: Recipient properties - object consisting of following fields:
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecipientTokenArgs', 'RecipientTokenArgsDict']]]] tokens: List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecipientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource can only be used with a workspace-level provider!

        In Delta Sharing, a recipient is an entity that receives shares from a provider. In Unity Catalog, a share is a securable object that represents an organization and associates it with a credential or secure sharing identifier that allows that organization to access one or more shares.

        As a data provider (sharer), you can define multiple recipients for any given Unity Catalog metastore, but if you want to share data from multiple metastores with a particular user or group of users, you must define the recipient separately for each metastore. A recipient can have access to multiple shares.

        A `Recipient` is contained within Metastore and can have permissions to `SELECT` from a list of shares.

        ## Example Usage

        ### Databricks Sharing with non databricks recipient

        Setting `authentication_type` type to `TOKEN` creates a temporary url to download a credentials file. This is used to
        authenticate to the sharing server to access data. This is for when the recipient is not using Databricks.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_random as random

        db2opensharecode = random.index.Password("db2opensharecode",
            length=16,
            special=True)
        current = databricks.get_current_user()
        db2open = databricks.Recipient("db2open",
            name=f"{current.alphanumeric}-recipient",
            comment="Made by Pulumi",
            authentication_type="TOKEN",
            sharing_code=db2opensharecode["result"],
            ip_access_list={
                "allowed_ip_addresses": [],
            })
        ```

        :param str resource_name: The name of the resource.
        :param RecipientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecipientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 ip_access_list: Optional[pulumi.Input[Union['RecipientIpAccessListArgs', 'RecipientIpAccessListArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 properties_kvpairs: Optional[pulumi.Input[Union['RecipientPropertiesKvpairsArgs', 'RecipientPropertiesKvpairsArgsDict']]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecipientTokenArgs', 'RecipientTokenArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecipientArgs.__new__(RecipientArgs)

            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["comment"] = comment
            __props__.__dict__["data_recipient_global_metastore_id"] = data_recipient_global_metastore_id
            __props__.__dict__["expiration_time"] = expiration_time
            __props__.__dict__["ip_access_list"] = ip_access_list
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["properties_kvpairs"] = properties_kvpairs
            __props__.__dict__["sharing_code"] = None if sharing_code is None else pulumi.Output.secret(sharing_code)
            __props__.__dict__["tokens"] = tokens
            __props__.__dict__["activated"] = None
            __props__.__dict__["activation_url"] = None
            __props__.__dict__["cloud"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["metastore_id"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sharingCode"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Recipient, __self__).__init__(
            'databricks:index/recipient:Recipient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[bool]] = None,
            activation_url: Optional[pulumi.Input[str]] = None,
            authentication_type: Optional[pulumi.Input[str]] = None,
            cloud: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[int]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[int]] = None,
            ip_access_list: Optional[pulumi.Input[Union['RecipientIpAccessListArgs', 'RecipientIpAccessListArgsDict']]] = None,
            metastore_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            properties_kvpairs: Optional[pulumi.Input[Union['RecipientPropertiesKvpairsArgs', 'RecipientPropertiesKvpairsArgsDict']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            sharing_code: Optional[pulumi.Input[str]] = None,
            tokens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecipientTokenArgs', 'RecipientTokenArgsDict']]]]] = None,
            updated_at: Optional[pulumi.Input[int]] = None,
            updated_by: Optional[pulumi.Input[str]] = None) -> 'Recipient':
        """
        Get an existing Recipient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_url: Full activation URL to retrieve the access token. It will be empty if the token is already retrieved.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] cloud: Cloud vendor of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[int] created_at: Time at which this recipient was created, in epoch milliseconds.
        :param pulumi.Input[str] created_by: Username of recipient creator.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when `authentication_type` is `DATABRICKS`.
        :param pulumi.Input[int] expiration_time: Expiration timestamp of the token in epoch milliseconds.
        :param pulumi.Input[Union['RecipientIpAccessListArgs', 'RecipientIpAccessListArgsDict']] ip_access_list: Recipient IP access list.
        :param pulumi.Input[str] metastore_id: Unique identifier of recipient's Unity Catalog metastore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] owner: Username/groupname/sp application_id of the recipient owner.
        :param pulumi.Input[Union['RecipientPropertiesKvpairsArgs', 'RecipientPropertiesKvpairsArgsDict']] properties_kvpairs: Recipient properties - object consisting of following fields:
        :param pulumi.Input[str] region: Cloud region of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecipientTokenArgs', 'RecipientTokenArgsDict']]]] tokens: List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        :param pulumi.Input[int] updated_at: Time at which this recipient was updated, in epoch milliseconds.
        :param pulumi.Input[str] updated_by: Username of recipient Token updater.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecipientState.__new__(_RecipientState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["activation_url"] = activation_url
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["data_recipient_global_metastore_id"] = data_recipient_global_metastore_id
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["ip_access_list"] = ip_access_list
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["properties_kvpairs"] = properties_kvpairs
        __props__.__dict__["region"] = region
        __props__.__dict__["sharing_code"] = sharing_code
        __props__.__dict__["tokens"] = tokens
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return Recipient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="activationUrl")
    def activation_url(self) -> pulumi.Output[str]:
        """
        Full activation URL to retrieve the access token. It will be empty if the token is already retrieved.
        """
        return pulumi.get(self, "activation_url")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[str]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[str]:
        """
        Cloud vendor of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[int]:
        """
        Time at which this recipient was created, in epoch milliseconds.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Username of recipient creator.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> pulumi.Output[Optional[str]]:
        """
        Required when `authentication_type` is `DATABRICKS`.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[Optional[int]]:
        """
        Expiration timestamp of the token in epoch milliseconds.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> pulumi.Output[Optional['outputs.RecipientIpAccessList']]:
        """
        Recipient IP access list.
        """
        return pulumi.get(self, "ip_access_list")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of recipient's Unity Catalog metastore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[str]]:
        """
        Username/groupname/sp application_id of the recipient owner.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="propertiesKvpairs")
    def properties_kvpairs(self) -> pulumi.Output[Optional['outputs.RecipientPropertiesKvpairs']]:
        """
        Recipient properties - object consisting of following fields:
        """
        return pulumi.get(self, "properties_kvpairs")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Cloud region of the recipient's Unity Catalog Metstore. This field is only present when the authentication_type is `DATABRICKS`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> pulumi.Output[Optional[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @property
    @pulumi.getter
    def tokens(self) -> pulumi.Output[Sequence['outputs.RecipientToken']]:
        """
        List of Recipient Tokens. This field is only present when the authentication_type is TOKEN. Each list element is an object with following attributes:
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[int]:
        """
        Time at which this recipient was updated, in epoch milliseconds.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[str]:
        """
        Username of recipient Token updater.
        """
        return pulumi.get(self, "updated_by")

