"""
Basic Usage Example

This example shows the simplest way to integrate LangSpend
with your OpenAI application.
"""

import os
from langspend import LangSpend, wrap_openai
from openai import OpenAI

# Initialize LangSpend
langspend = LangSpend(
    api_key=os.getenv('LANGSPEND_API_KEY', 'lsp_your_api_key_here')
)

# Wrap your OpenAI client
openai = wrap_openai(
    OpenAI(api_key=os.getenv('OPENAI_API_KEY')),
    langspend
)

async def main():
    print('Making LLM request...')
    
    # Use OpenAI as normal - tracking happens automatically!
    response = openai.chat.completions.create(
        model='gpt-3.5-turbo',
        messages=[
            {'role': 'user', 'content': 'What is the capital of France?'}
        ]
    )
    
    print('Response:', response.choices[0].message.content)
    print('\n✅ Request tracked automatically in the background!')

if __name__ == '__main__':
    import asyncio
    asyncio.run(main())
