"""
LangSpend Python SDK

A Python SDK for tracking LLM costs with customer attribution.
Supports OpenAI, Anthropic, AWS Bedrock, and Google Vertex AI.
"""

from .client import LangSpend
from .types import Customer, Feature, LangSpendTags, TrackResponse, TrackingData
from .wrappers import wrap_openai, wrap_anthropic, wrap_bedrock, wrap_vertex

__version__ = "1.0.0"
__author__ = "LangSpend"
__email__ = "support@langspend.com"

__all__ = [
    "LangSpend",
    "Customer", 
    "Feature",
    "LangSpendTags",
    "TrackResponse",
    "TrackingData",
    "wrap_openai",
    "wrap_anthropic", 
    "wrap_bedrock",
    "wrap_vertex",
]

# CLI entry point
def cli() -> None:
    """CLI entry point for the langspend command"""
    from .cli import main
    main()
