"""
Feature name normalization utilities
"""

import re
from typing import Optional


def normalize_feature_name(name: str) -> str:
    """
    Normalize a feature name to a consistent format.
    
    Args:
        name: Raw feature name (endpoint, function name, etc.)
        
    Returns:
        Normalized feature name
    """
    if not name:
        return "uncategorized"
    
    # Convert to lowercase
    normalized = name.lower()
    
    # Replace common separators with hyphens
    normalized = re.sub(r'[_\s]+', '-', normalized)
    
    # Remove special characters except hyphens
    normalized = re.sub(r'[^a-z0-9\-]', '', normalized)
    
    # Remove multiple consecutive hyphens
    normalized = re.sub(r'-+', '-', normalized)
    
    # Remove leading/trailing hyphens
    normalized = normalized.strip('-')
    
    # Ensure it's not empty
    if not normalized:
        return "uncategorized"
    
    return normalized
