from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

with open("requirements.txt", "r", encoding="utf-8") as fh:
    requirements = [line.strip() for line in fh if line.strip() and not line.startswith("#")]

setup(
    name="langspend",
    version="1.0.0",
    author="LangSpend",
    author_email="support@langspend.com",
    description="LangSpend Python SDK - Track LLM costs and usage with customer attribution. Requires LangSpend API key for production use.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/langspend/langspend-python",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
    python_requires=">=3.8",
    install_requires=requirements,
    extras_require={
        "openai": ["openai>=1.0.0"],
        "anthropic": ["anthropic>=0.7.0"],
        "bedrock": ["boto3>=1.26.0"],
        "vertex": ["google-cloud-aiplatform>=1.38.0"],
        "all": ["openai>=1.0.0", "anthropic>=0.7.0", "boto3>=1.26.0", "google-cloud-aiplatform>=1.38.0"],
    },
    keywords="llm, ai, cost-tracking, openai, anthropic, bedrock, langspend",
    project_urls={
        "Bug Reports": "https://github.com/langspend/langspend-python/issues",
        "Source": "https://github.com/langspend/langspend-python",
        "Documentation": "https://docs.langspend.com/python",
    },
)
