# Generated by Django 1.9.1 on 2016-02-20 21:11

from django.db import migrations


def is_course_archived(course):
    assert (course._participant_count is None) == (course._voter_count is None)
    return course._participant_count is not None


def is_semester_archived(semester):
    if semester.course_set.count() == 0:
        return False
    first_course_is_archived = is_course_archived(semester.course_set.first())
    assert all(is_course_archived(course) == first_course_is_archived for course in semester.course_set.all())
    return first_course_is_archived


def set_is_archived(apps, _schema_editor):
    Semester = apps.get_model("evaluation", "Semester")
    for semester in Semester.objects.all():
        semester.is_archived = is_semester_archived(semester)
        semester.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0040_add_semester_is_archived"),
    ]

    operations = [
        migrations.RunPython(set_is_archived, reverse_code=migrations.RunPython.noop),
    ]
