# Generated by Django 1.9 on 2016-02-21 18:21

import django.db.models.deletion
from django.db import migrations, models


def add_course_types(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    CourseType = apps.get_model("evaluation", "CourseType")

    for course in Course.objects.all():
        CourseType.objects.get_or_create(name_de=course.type, name_en=course.type)


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0043_auto_20160221_1543"),
    ]

    operations = [
        migrations.CreateModel(
            name="CourseType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name_de", models.CharField(max_length=1024, unique=True, verbose_name="name (german)")),
                ("name_en", models.CharField(max_length=1024, unique=True, verbose_name="name (english)")),
            ],
            options={
                "ordering": ["name_de"],
            },
        ),
        migrations.RunPython(add_course_types, reverse_code=migrations.RunPython.noop),
        migrations.RenameField(
            model_name="course",
            old_name="type",
            new_name="type_old",
        ),
        migrations.AlterField(
            model_name="course",
            name="type_old",
            field=models.CharField(max_length=1024, null=True, verbose_name="type"),
        ),
        migrations.AddField(
            model_name="course",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="courses",
                to="evaluation.CourseType",
                verbose_name="course type",
                default=1,
            ),
        ),
    ]
