# Generated by Django 1.9 on 2016-02-21 18:21

from django.db import migrations


def populate_course_types(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    CourseType = apps.get_model("evaluation", "CourseType")

    for course in Course.objects.all():
        course.type = CourseType.objects.get(name_de=course.type_old)
        course.save()


def revert_course_types(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")

    for course in Course.objects.all():
        course.type_old = course.type.name_de
        course.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0044_add_course_type_model"),
    ]

    operations = [
        migrations.RunPython(populate_course_types, reverse_code=revert_course_types),
    ]
