# Generated by Django 1.11.3 on 2017-07-03 18:31

import uuid

from django.db import migrations, models


def fill_textanswer_uuid(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    TextAnswer = apps.get_model("evaluation", "TextAnswer")
    for obj in TextAnswer.objects.using(db_alias).all():
        obj.uuid = uuid.uuid4()
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0061_editor_review_reminder_template"),
    ]

    # Based on
    # https://gist.github.com/smcoll/8bb867dc631433c01fd0

    operations = [
        migrations.AddField(
            model_name="textanswer",
            name="uuid",
            field=models.UUIDField(null=True),
        ),
        migrations.RunPython(fill_textanswer_uuid, migrations.RunPython.noop),
        migrations.AlterField(
            model_name="textanswer",
            name="uuid",
            field=models.UUIDField(primary_key=False, default=uuid.uuid4, serialize=False, editable=False),
        ),
        # this causes trouble with sqlite. We have two open bug reports with django for this, see
        # https://code.djangoproject.com/ticket/29790 and https://code.djangoproject.com/ticket/28541
        # We can not get this to work with sqlite and postgres right now and we want django2.1, we only
        # support postgres here. For sqlite, you need to rename the field here and move the RemoveField to
        # the end.
        migrations.RemoveField(model_name="textanswer", name="id"),
        migrations.RenameField(model_name="textanswer", old_name="uuid", new_name="id"),
        migrations.AlterField(
            model_name="textanswer",
            name="id",
            field=models.UUIDField(primary_key=True, default=uuid.uuid4, serialize=False, editable=False),
        ),
        migrations.AlterModelOptions(
            name="textanswer",
            options={"ordering": ["id"], "verbose_name": "text answer", "verbose_name_plural": "text answers"},
        ),
    ]
