# Generated by Django 2.0.5 on 2018-05-11 11:58

from django.db import migrations, models

SINGLE_RESULT_QUESTIONNAIRE_NAME = "Single result"


def populate_is_single_result(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    for course in Course.objects.all():
        if course.contributions.filter(
            responsible=True, questionnaires__name_en=SINGLE_RESULT_QUESTIONNAIRE_NAME
        ).exists():
            course.is_single_result = True
            course.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0076_add_semester_short_names"),
    ]

    operations = [
        migrations.AddField(
            model_name="course",
            name="is_single_result",
            field=models.BooleanField(default=False, verbose_name="is single result"),
        ),
        migrations.RunPython(populate_is_single_result, reverse_code=migrations.RunPython.noop),
    ]
