# Generated by Django 2.0.5 on 2018-05-14 19:59

from django.db import migrations


def populate_voter_and_participant_count(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    for course in Course.objects.filter(
        state="published", semester__participations_are_archived=False, is_single_result=False
    ):
        course._voter_count = course.voters.count()
        course._participant_count = course.participants.count()
        course.save()


def delete_voter_and_participant_count(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    for course in Course.objects.filter(
        state="published", semester__participations_are_archived=False, is_single_result=False
    ):
        course._voter_count = None
        course._participant_count = None
        course.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0077_course_is_single_result"),
    ]

    operations = [
        migrations.RunPython(populate_voter_and_participant_count, reverse_code=delete_voter_and_participant_count),
    ]
