# Generated by Django 2.0.7 on 2018-08-13 21:09

from django.db import migrations


def insert_general_contribution(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    Contribution = apps.get_model("evaluation", "Contribution")
    for single_result in Course.objects.filter(is_single_result=True):
        assert not single_result.contributions.filter(contributor=None).exists()
        Contribution.objects.create(course=single_result, contributor=None)


def remove_general_contribution(apps, _schema_editor):
    Course = apps.get_model("evaluation", "Course")
    Contribution = apps.get_model("evaluation", "Contribution")
    for single_result in Course.objects.filter(is_single_result=True):
        course = Contribution.objects.get(course=single_result, contributor=None)
        assert not course.questionnaires.exists()
        course.delete()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0082_add_related_names_fix_verbose_name"),
    ]

    operations = [
        migrations.RunPython(remove_general_contribution, reverse_code=insert_general_contribution),
    ]
