# Generated by Django 2.0.5 on 2018-12-08 14:07

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("grades", "0013_prepare_rename_course_to_evaluation"),
        ("evaluation", "0090_add_bipolar_question_type"),
    ]

    operations = [
        migrations.RenameModel(
            old_name="Course",
            new_name="Evaluation",
        ),
        migrations.AlterModelOptions(
            name="evaluation",
            options={"ordering": ("name_de",), "verbose_name": "evaluation", "verbose_name_plural": "evaluations"},
        ),
        migrations.AlterUniqueTogether(
            name="evaluation",
            unique_together={("semester", "name_de"), ("semester", "name_en")},
        ),
        migrations.RenameField(
            model_name="contribution",
            old_name="course",
            new_name="evaluation",
        ),
        migrations.AlterUniqueTogether(
            name="contribution",
            unique_together={("evaluation", "contributor")},
        ),
        migrations.AlterField(
            model_name="contribution",
            name="evaluation",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contributions",
                to="evaluation.Evaluation",
                verbose_name="evaluation",
            ),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="degrees",
            field=models.ManyToManyField(related_name="evaluations", to="evaluation.Degree", verbose_name="degrees"),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="last_modified_user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="evaluations_last_modified+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="participants",
            field=models.ManyToManyField(
                blank=True,
                related_name="evaluations_participating_in",
                to=settings.AUTH_USER_MODEL,
                verbose_name="participants",
            ),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="semester",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="evaluations",
                to="evaluation.Semester",
                verbose_name="semester",
            ),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="evaluations",
                to="evaluation.CourseType",
                verbose_name="course type",
            ),
        ),
        migrations.AlterField(
            model_name="evaluation",
            name="voters",
            field=models.ManyToManyField(
                blank=True, related_name="evaluations_voted_for", to=settings.AUTH_USER_MODEL, verbose_name="voters"
            ),
        ),
    ]
