# Generated by Django 2.1.8 on 2019-05-28 15:34

from django.db import migrations, models

HIDDEN = 0
MANAGERS = 1
EDITORS = 2


def fill_questionnaire_visibility(apps, _schema_editor):
    Questionnaire = apps.get_model("evaluation", "Questionnaire")
    for questionnaire in Questionnaire.objects.all():
        if questionnaire.obsolete:
            questionnaire.visibility = HIDDEN
        elif questionnaire.manager_only:
            questionnaire.visibility = MANAGERS
        else:
            questionnaire.visibility = EDITORS
        questionnaire.save()


def remove_questionnaire_visibility(apps, _schema_editor):
    Questionnaire = apps.get_model("evaluation", "Questionnaire")
    for questionnaire in Questionnaire.objects.all():
        questionnaire.obsolete = questionnaire.visibility == HIDDEN
        questionnaire.manager_only = questionnaire.visibility == MANAGERS
        questionnaire.save()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0102_individual_publishing_notice_email_template"),
    ]

    operations = [
        migrations.AddField(
            model_name="questionnaire",
            name="visibility",
            field=models.IntegerField(
                choices=[(0, "Don't show"), (1, "Managers only"), (2, "Managers and editors")],
                default=1,
                verbose_name="visibility",
            ),
        ),
        migrations.RunPython(fill_questionnaire_visibility, reverse_code=remove_questionnaire_visibility),
        migrations.RemoveField(
            model_name="questionnaire",
            name="manager_only",
        ),
        migrations.RemoveField(
            model_name="questionnaire",
            name="obsolete",
        ),
    ]
