# Generated by Django 4.2.2 on 2023-07-03 22:18

import django.db.models.functions.datetime
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("evaluation", "0136_alter_userprofile_first_name_chosen_and_more"),
    ]

    operations = [
        migrations.AddConstraint(
            model_name="evaluation",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    (
                        "vote_end_date__gte",
                        django.db.models.functions.datetime.TruncDate(models.F("vote_start_datetime")),
                    )
                ),
                name="check_evaluation_start_before_end",
            ),
        ),
        migrations.AddConstraint(
            model_name="evaluation",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    ("_participant_count__isnull", True),
                    ("_voter_count__isnull", True),
                    _connector="XOR",
                    _negated=True,
                ),
                name="check_evaluation_participant_count_and_voter_count_both_set_or_not_set",
            ),
        ),
        migrations.AddConstraint(
            model_name="question",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    models.Q(("type", 0), ("type", 5), _connector="OR", _negated=True),
                    models.Q(("allows_additional_textanswers", True), _negated=True),
                    _connector="OR",
                ),
                name="check_evaluation_textanswer_or_heading_question_has_no_additional_textanswers",
            ),
        ),
        migrations.AddConstraint(
            model_name="textanswer",
            constraint=models.CheckConstraint(
                condition=models.Q(("answer", models.F("original_answer")), _negated=True),
                name="check_evaluation_text_answer_is_modified",
            ),
        ),
    ]
