# Generated by Django 5.1.3 on 2025-02-07 20:27

from django.db import migrations, models


def remove_dropout_questionnaires(apps, _schema_editor):
    questionnaire_model = apps.get_model("evaluation", "Questionnaire")

    for questionnaire in questionnaire_model.objects.filter(type=5):
        for question in questionnaire.questions.all():
            question.textanswer_set.all().delete()
            question.ratinganswercounter_set.all().delete()
            question.delete()
        questionnaire.delete()


class Migration(migrations.Migration):

    dependencies = [
        ("evaluation", "0148_course_cms_id_evaluation_cms_id"),
    ]

    operations = [
        migrations.AddField(
            model_name="evaluation",
            name="dropout_count",
            field=models.IntegerField(default=0, verbose_name="dropout count"),
        ),
        migrations.RunPython(migrations.RunPython.noop, reverse_code=remove_dropout_questionnaires),
        migrations.AlterField(
            model_name="questionnaire",
            name="type",
            field=models.IntegerField(
                choices=[
                    (5, "Dropout questionnaire"),
                    (10, "Top questionnaire"),
                    (20, "Contributor questionnaire"),
                    (30, "Bottom questionnaire"),
                ],
                default=10,
                verbose_name="type",
            ),
        ),
    ]
