# Generated by Django 5.1.3 on 2025-01-27 20:24

from django.db import migrations, models


def update_names(apps, _schema_editor):
    RewardPointRedemptionEvent = apps.get_model("rewards", "RewardPointRedemptionEvent")
    for event in RewardPointRedemptionEvent.objects.all():
        event.name_de = event.name_en
        event.save()


class Migration(migrations.Migration):

    dependencies = [
        ("rewards", "0006_rewardpointredemptionevent_step"),
    ]

    operations = [
        migrations.RenameField(
            model_name="rewardpointredemptionevent",
            old_name="name",
            new_name="name_en",
        ),
        migrations.AlterField(
            model_name="rewardpointredemptionevent",
            name="name_en",
            field=models.CharField(max_length=1024, unique=True, verbose_name="name (english)"),
        ),
        migrations.AddField(
            model_name="rewardpointredemptionevent",
            name="name_de",
            field=models.CharField(null=True, unique=True, max_length=1024, verbose_name="name (german)"),
            preserve_default=False,
        ),
        migrations.RunPython(update_names, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name="rewardpointredemptionevent",
            name="name_de",
            field=models.CharField(max_length=1024, unique=True, verbose_name="name (german)"),
        ),
    ]
