/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OptimalBinningUtil {
    private OptimalBinningUtil() {
    }

    public static <E> List<E> ensureCategory(List<E> categories, E category) {
        if (!categories.contains(category)) {
            categories = new ArrayList<E>(categories);
            categories.add(category);
        }
        return categories;
    }

    public static void checkIncreasingOrder(List<Number> bins) {
        Iterator<Number> it = bins.iterator();
        Number prevBin = it.next();
        while (it.hasNext()) {
            Number bin = it.next();
            if (bin.doubleValue() <= prevBin.doubleValue()) {
                throw new IllegalArgumentException();
            }
            prevBin = bin;
        }
    }

    public static int sumExact(Collection<Integer> values) {
        int result = 0;
        for (Integer value : values) {
            result = Math.addExact(result, value);
        }
        return result;
    }
}

