/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.discrete;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import statsmodels.discrete.MultinomialRegressionModel;

public class MNLogit
extends MultinomialRegressionModel {
    public MNLogit(String module, String name) {
        super(module, name);
    }

    public RegressionModel encodeModel(List<? extends Number> params, Schema schema) {
        Integer j = this.getJ();
        Integer k = this.getK();
        Integer kConstant = this.getKConstant();
        Label label = schema.getLabel();
        List<? extends Feature> features = schema.getFeatures();
        CategoricalLabel categoricalLabel = (CategoricalLabel)label;
        ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
        RegressionTable regressionTable = new RegressionTable((Number)0.0).setTargetCategory(categoricalLabel.getValue(0));
        regressionTables.add(regressionTable);
        int rows = categoricalLabel.size() - 1;
        int columns = k;
        int kIndex = 0;
        if (kConstant != 0) {
            if (kConstant == 1) {
                features = MNLogit.dropInterceptFeature(features, kIndex);
            } else {
                throw new IllegalArgumentException();
            }
        }
        for (int i = 0; i < rows; ++i) {
            ArrayList coefficients = new ArrayList(FortranMatrixUtil.getRow(params, (int)rows, (int)columns, (int)i));
            Number intercept = null;
            if (kConstant != 0) {
                if (kConstant == 1) {
                    intercept = (Number)coefficients.remove(kIndex);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            RegressionTable regressionTable2 = RegressionModelUtil.createRegressionTable(features, coefficients, intercept).setTargetCategory(categoricalLabel.getValue(i + 1));
            regressionTables.add(regressionTable2);
        }
        RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (DiscreteLabel)categoricalLabel));
        return regressionModel;
    }
}

