/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import hex.genmodel.MojoModel;
import hex.genmodel.algos.drf.DrfMojoModel;
import hex.genmodel.algos.ensemble.StackedEnsembleMojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import hex.genmodel.algos.glm.GlmMultinomialMojoModel;
import hex.genmodel.algos.glm.GlmOrdinalMojoModel;
import hex.genmodel.algos.isofor.IsolationForestMojoModel;
import hex.genmodel.algos.isoforextended.ExtendedIsolationForestMojoModel;
import org.jpmml.h2o.Converter;
import org.jpmml.h2o.DrfMojoModelConverter;
import org.jpmml.h2o.ExtendedIsolationForestMojoModelConverter;
import org.jpmml.h2o.GbmMojoModelConverter;
import org.jpmml.h2o.GlmMojoModelConverter;
import org.jpmml.h2o.GlmMultinomialMojoModelConverter;
import org.jpmml.h2o.GlmOrdinalMojoModelConverter;
import org.jpmml.h2o.IsolationForestMojoModelConverter;
import org.jpmml.h2o.StackedEnsembleMojoModelConverter;
import org.jpmml.h2o.XGBoostMojoModel;
import org.jpmml.h2o.XGBoostMojoModelConverter;

public class ConverterFactory {
    protected ConverterFactory() {
    }

    public Converter<? extends MojoModel> newConverter(MojoModel model) {
        if (model instanceof DrfMojoModel) {
            return new DrfMojoModelConverter((DrfMojoModel)model);
        }
        if (model instanceof ExtendedIsolationForestMojoModel) {
            return new ExtendedIsolationForestMojoModelConverter((ExtendedIsolationForestMojoModel)model);
        }
        if (model instanceof GbmMojoModel) {
            return new GbmMojoModelConverter((GbmMojoModel)model);
        }
        if (model instanceof GlmMojoModel) {
            return new GlmMojoModelConverter((GlmMojoModel)model);
        }
        if (model instanceof GlmMultinomialMojoModel) {
            return new GlmMultinomialMojoModelConverter((GlmMultinomialMojoModel)model);
        }
        if (model instanceof GlmOrdinalMojoModel) {
            return new GlmOrdinalMojoModelConverter((GlmOrdinalMojoModel)model);
        }
        if (model instanceof IsolationForestMojoModel) {
            return new IsolationForestMojoModelConverter((IsolationForestMojoModel)model);
        }
        if (model instanceof StackedEnsembleMojoModel) {
            return new StackedEnsembleMojoModelConverter((StackedEnsembleMojoModel)model);
        }
        if (model instanceof XGBoostMojoModel) {
            return new XGBoostMojoModelConverter((XGBoostMojoModel)model);
        }
        throw new IllegalArgumentException("No converter for MOJO model " + model);
    }

    public static ConverterFactory newConverterFactory() {
        return new ConverterFactory();
    }
}

