/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import hex.genmodel.algos.isofor.IsolationForestMojoModel;
import java.lang.reflect.Field;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.transformations.AbstractTransformation;
import org.jpmml.h2o.SharedTreeMojoModelConverter;

public class IsolationForestMojoModelConverter
extends SharedTreeMojoModelConverter<IsolationForestMojoModel> {
    private static final Field FIELD_MAX_PATH_LENGTH;
    private static final Field FIELD_MIN_PATH_LENGTH;

    public IsolationForestMojoModelConverter(IsolationForestMojoModel model) {
        super(model);
    }

    public MiningModel encodeModel(Schema schema) {
        int maxPathLength;
        IsolationForestMojoModel model = (IsolationForestMojoModel)this.getModel();
        final int minPathLength = IsolationForestMojoModelConverter.getMinPathLength(model);
        if (minPathLength >= (maxPathLength = IsolationForestMojoModelConverter.getMaxPathLength(model))) {
            throw new IllegalArgumentException();
        }
        final List<TreeModel> treeModels = this.encodeTreeModels(schema);
        AbstractTransformation anomalyScore = new AbstractTransformation(){

            public String getName(String name) {
                return "anomalyScore";
            }

            public boolean isFinalResult() {
                return true;
            }

            public Expression createExpression(FieldRef fieldRef) {
                return ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)((double)maxPathLength / (double)treeModels.size())), fieldRef}), ExpressionUtil.createConstant((Number)((double)(maxPathLength - minPathLength) / (double)treeModels.size()))});
            }
        };
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(null)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels)).setOutput(ModelUtil.createPredictedOutput((String)"meanPathLength", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{anomalyScore}));
        return miningModel;
    }

    @Override
    protected void ensureScore(Node node, double score) {
    }

    public static int getMaxPathLength(IsolationForestMojoModel model) {
        return (Integer)IsolationForestMojoModelConverter.getFieldValue(FIELD_MAX_PATH_LENGTH, model);
    }

    public static int getMinPathLength(IsolationForestMojoModel model) {
        return (Integer)IsolationForestMojoModelConverter.getFieldValue(FIELD_MIN_PATH_LENGTH, model);
    }

    static {
        try {
            FIELD_MAX_PATH_LENGTH = IsolationForestMojoModel.class.getDeclaredField("_max_path_length");
            FIELD_MIN_PATH_LENGTH = IsolationForestMojoModel.class.getDeclaredField("_min_path_length");
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

