/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.google.common.io.ByteStreams;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.TmpMojoReaderBackend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;

public class MojoModelUtil {
    private MojoModelUtil() {
    }

    public static MojoModel readFrom(InputStream is) throws IOException {
        File tmpZipFile = File.createTempFile("mojo", ".zip");
        try (FileOutputStream os = new FileOutputStream(tmpZipFile);){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        return MojoModelUtil.readFrom(tmpZipFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MojoModel readFrom(File tmpZipFile, final boolean deleterAfterRead) throws IOException {
        try (TmpMojoReaderBackend mojoReaderBackend = new TmpMojoReaderBackend(tmpZipFile){

            public void close() throws IOException {
                if (!deleterAfterRead) {
                    try {
                        Field field = TmpMojoReaderBackend.class.getDeclaredField("_tempZipFile");
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        field.set((Object)this, null);
                    }
                    catch (ReflectiveOperationException roe) {
                        throw new RuntimeException(roe);
                    }
                }
                super.close();
            }
        };){
            MojoModel mojoModel = ModelMojoReader.readFrom((MojoReaderBackend)mojoReaderBackend, (boolean)true);
            return mojoModel;
        }
    }
}

