/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Interval", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Interval")
@JsonPropertyOrder(value={"closure", "leftMargin", "rightMargin", "extensions"})
public class Interval
extends PMMLObject
implements HasExtensions<Interval> {
    @XmlAttribute(name="closure", required=true)
    @JsonProperty(value="closure")
    private Closure closure;
    @XmlAttribute(name="leftMargin")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="leftMargin")
    private Number leftMargin;
    @XmlAttribute(name="rightMargin")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="rightMargin")
    private Number rightMargin;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371273L;

    public Interval() {
    }

    @ValueConstructor
    public Interval(@Property(value="closure") Closure closure) {
        this.closure = closure;
    }

    public Closure requireClosure() {
        if (this.closure == null) {
            throw new MissingAttributeException(this, PMMLAttributes.INTERVAL_CLOSURE);
        }
        return this.closure;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public Interval setClosure(@Property(value="closure") Closure closure) {
        this.closure = closure;
        return this;
    }

    public Number getLeftMargin() {
        return this.leftMargin;
    }

    public Interval setLeftMargin(@Property(value="leftMargin") Number leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public Number getRightMargin() {
        return this.rightMargin;
    }

    public Interval setRightMargin(@Property(value="rightMargin") Number rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Interval addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Closure implements StringValue<Closure>
    {
        OPEN_CLOSED("openClosed"),
        OPEN_OPEN("openOpen"),
        CLOSED_OPEN("closedOpen"),
        CLOSED_CLOSED("closedClosed");

        private final String value;

        private Closure(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Closure fromValue(String v) {
            for (Closure c : Closure.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

