/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasOpType;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="Target", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "targetValues"})
@JsonRootName(value="Target")
@JsonPropertyOrder(value={"field", "opType", "castInteger", "min", "max", "rescaleConstant", "rescaleFactor", "extensions", "targetValues"})
public class Target
extends PMMLObject
implements HasExtensions<Target>,
HasOpType<Target>,
HasTargetFieldReference<Target>,
Indexable<String> {
    @XmlAttribute(name="field")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    @Optional(value=Version.PMML_4_3)
    private String field;
    @XmlAttribute(name="optype")
    @JsonProperty(value="optype")
    private OpType opType;
    @XmlAttribute(name="castInteger")
    @JsonProperty(value="castInteger")
    private CastInteger castInteger;
    @XmlAttribute(name="min")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="min")
    @Added(value=Version.PMML_3_1)
    private Number min;
    @XmlAttribute(name="max")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="max")
    @Added(value=Version.PMML_3_1)
    private Number max;
    @XmlAttribute(name="rescaleConstant")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="rescaleConstant")
    @Added(value=Version.PMML_3_1)
    private Number rescaleConstant;
    @XmlAttribute(name="rescaleFactor")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="rescaleFactor")
    @Added(value=Version.PMML_3_1)
    private Number rescaleFactor;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="TargetValue", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TargetValue")
    @Optional(value=Version.PMML_3_1)
    @CollectionElementType(value=TargetValue.class)
    private List<TargetValue> targetValues;
    private static final Number DEFAULT_RESCALE_CONSTANT = new RealNumberAdapter().unmarshal("0");
    private static final Number DEFAULT_RESCALE_FACTOR = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371273L;

    @Override
    public String getKey() {
        return this.getTargetField();
    }

    @Override
    public String getTargetField() {
        return this.getField();
    }

    @Override
    public Target setTargetField(String targetField) {
        return this.setField(targetField);
    }

    public String getField() {
        return this.field;
    }

    public Target setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public Target setOpType(@Property(value="opType") OpType opType) {
        this.opType = opType;
        return this;
    }

    public CastInteger getCastInteger() {
        return this.castInteger;
    }

    public Target setCastInteger(@Property(value="castInteger") CastInteger castInteger) {
        this.castInteger = castInteger;
        return this;
    }

    public Number getMin() {
        return this.min;
    }

    public Target setMin(@Property(value="min") Number min) {
        this.min = min;
        return this;
    }

    public Number getMax() {
        return this.max;
    }

    public Target setMax(@Property(value="max") Number max) {
        this.max = max;
        return this;
    }

    public Number getRescaleConstant() {
        if (this.rescaleConstant == null) {
            return DEFAULT_RESCALE_CONSTANT;
        }
        return this.rescaleConstant;
    }

    public Target setRescaleConstant(@Property(value="rescaleConstant") Number rescaleConstant) {
        this.rescaleConstant = rescaleConstant;
        return this;
    }

    public Number getRescaleFactor() {
        if (this.rescaleFactor == null) {
            return DEFAULT_RESCALE_FACTOR;
        }
        return this.rescaleFactor;
    }

    public Target setRescaleFactor(@Property(value="rescaleFactor") Number rescaleFactor) {
        this.rescaleFactor = rescaleFactor;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Target addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValues() {
        return this.targetValues != null && !this.targetValues.isEmpty();
    }

    public List<TargetValue> getTargetValues() {
        if (this.targetValues == null) {
            this.targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    public Target addTargetValues(TargetValue ... targetValues) {
        this.getTargetValues().addAll(Arrays.asList(targetValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTargetValues()) {
                status = PMMLObject.traverse(visitor, this.getTargetValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CastInteger implements StringValue<CastInteger>
    {
        ROUND("round"),
        CEILING("ceiling"),
        FLOOR("floor");

        private final String value;

        private CastInteger(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static CastInteger fromValue(String v) {
            for (CastInteger c : CastInteger.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

