/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.hist_gradient_boosting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictUtil;
import sklearn.SkLearnRegressor;
import sklearn.compose.ColumnTransformer;
import sklearn.ensemble.hist_gradient_boosting.BinMapper;
import sklearn.ensemble.hist_gradient_boosting.HistGradientBoostingUtil;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;

public class HistGradientBoostingRegressor
extends SkLearnRegressor {
    public HistGradientBoostingRegressor(String module, String name) {
        super(module, name);
    }

    public MiningModel encodeModel(Schema schema) {
        Number baselinePrediction = this.getBaselinePrediction();
        BinMapper binMapper = this.getBinMapper();
        List<List<TreePredictor>> predictors = this.getPredictors();
        ColumnTransformer preprocessor = this.getPreprocessor();
        if (preprocessor != null) {
            schema = HistGradientBoostingUtil.preprocess(preprocessor, schema);
        }
        return HistGradientBoostingUtil.encodeHistGradientBoosting(predictors, binMapper, Collections.singletonList(baselinePrediction), 0, schema);
    }

    public Number getBaselinePrediction() {
        try {
            return this.getNumber("_baseline_prediction");
        }
        catch (AttributeException ae) {
            List baselinePredictions = this.getNumberArray("_baseline_prediction");
            ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{baselinePredictions});
            return (Number)baselinePredictions.get(0);
        }
    }

    public BinMapper getBinMapper() {
        return (BinMapper)((Object)this.getOptional("_bin_mapper", BinMapper.class));
    }

    public List<List<TreePredictor>> getPredictors() {
        return this.getList("_predictors", List.class);
    }

    public ColumnTransformer getPreprocessor() {
        return (ColumnTransformer)this.getOptional("_preprocessor", ColumnTransformer.class);
    }
}

