/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_extraction.text;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.feature_extraction.text.CountVectorizer;
import sklearn.feature_extraction.text.TfidfTransformer;

public class TfidfVectorizer
extends CountVectorizer {
    public TfidfVectorizer(String module, String name) {
        super(module, name);
    }

    @Override
    public TypeInfo getDType() {
        TfidfTransformer transformer;
        TypeInfo dtype = super.getDType();
        if (dtype != null && (transformer = this.getTransformer()) != null) {
            DataType dataType = dtype.getDataType();
            switch (dataType) {
                case BOOLEAN: 
                case INTEGER: {
                    return null;
                }
                case FLOAT: 
                case DOUBLE: {
                    return dtype;
                }
            }
        }
        return dtype;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        TfidfTransformer transformer = this.getTransformer();
        String norm = transformer.getNorm();
        if (norm != null) {
            throw new IllegalArgumentException(norm);
        }
        return super.encodeFeatures(features, encoder);
    }

    @Override
    public DefineFunction encodeDefineFunction(Feature feature, SkLearnEncoder encoder) {
        TfidfTransformer transformer = this.getTransformer();
        Boolean sublinearTf = transformer.getSublinearTf();
        Boolean useIdf = transformer.getUseIdf();
        DefineFunction defineFunction = super.encodeDefineFunction(feature, encoder);
        if (!sublinearTf.booleanValue() && !useIdf.booleanValue()) {
            return defineFunction;
        }
        Expression expression = defineFunction.requireExpression();
        if (sublinearTf.booleanValue()) {
            DefineFunction sublinearDefineFunction = TfidfVectorizer.ensureSublinearDefineFunction(encoder);
            expression = ExpressionUtil.createApply((DefineFunction)sublinearDefineFunction, (Expression[])new Expression[]{expression});
        }
        if (useIdf.booleanValue()) {
            ParameterField weightField = new ParameterField("weight");
            defineFunction.addParameterFields(new ParameterField[]{weightField});
            expression = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{expression, new FieldRef((Field)weightField)});
        }
        defineFunction.setDataType(DataType.DOUBLE).setExpression(expression);
        return defineFunction;
    }

    @Override
    public Apply encodeApply(DefineFunction defineFunction, Feature feature, int index, String term) {
        TfidfTransformer transformer = this.getTransformer();
        Apply apply = super.encodeApply(defineFunction, feature, index, term);
        Boolean useIdf = transformer.getUseIdf();
        if (useIdf.booleanValue()) {
            Number weight = transformer.getWeight(index);
            apply.addExpressions(new Expression[]{ExpressionUtil.createConstant((Number)weight)});
        }
        return apply;
    }

    @Override
    public String functionName() {
        TfidfTransformer transformer = this.getTransformer();
        Boolean useIdf = transformer.getUseIdf();
        if (useIdf.booleanValue()) {
            return "tf-idf";
        }
        return super.functionName();
    }

    public TfidfTransformer getTransformer() {
        return (TfidfTransformer)((Object)this.get("_tfidf", TfidfTransformer.class));
    }

    private static DefineFunction ensureSublinearDefineFunction(SkLearnEncoder encoder) {
        DefineFunction defineFunction = encoder.getDefineFunction("sublinearize");
        if (defineFunction == null) {
            ParameterField valueField = new ParameterField("x");
            Apply apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{new FieldRef((Field)valueField), ExpressionUtil.createConstant((Number)0)}), ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"ln", (Expression[])new Expression[]{new FieldRef((Field)valueField)}), ExpressionUtil.createConstant((Number)1)}), ExpressionUtil.createConstant((Number)0)});
            defineFunction = new DefineFunction("sublinearize", OpType.CONTINUOUS, DataType.DOUBLE, null, (Expression)apply).addParameterFields(new ParameterField[]{valueField});
            encoder.addDefineFunction(defineFunction);
        }
        return defineFunction;
    }
}

