/*
 * Decompiled with CFR 0.152.
 */
package sklearn.model_selection;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.Model;
import org.jpmml.converter.Schema;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictUtil;
import sklearn.Classifier;
import sklearn.HasEstimator;
import sklearn.SkLearnClassifier;
import sklearn.model_selection.ThresholdClassifierUtil;

public class FixedThresholdClassifier
extends SkLearnClassifier
implements HasEstimator<Classifier> {
    private static final String RESPONSEMETHOD_PREDICT_PROBA = "predict_proba";
    private static final String THRESHOLD_AUTO = "auto";

    public FixedThresholdClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public List<?> getClasses() {
        Classifier estimator = this.getEstimator();
        return estimator.getClasses();
    }

    @Override
    public Model encodeModel(Schema schema) {
        Classifier estimator = this.getEstimator();
        String responseMethod = this.getResponseMethod();
        Number threshold = this.getThreshold();
        return ThresholdClassifierUtil.encodeModel(estimator, threshold, schema);
    }

    @Override
    public Classifier getEstimator() {
        return (Classifier)this.get("estimator_", Classifier.class);
    }

    public String getResponseMethod() {
        return (String)this.getEnum("response_method", arg_0 -> ((FixedThresholdClassifier)this).getString(arg_0), Arrays.asList(RESPONSEMETHOD_PREDICT_PROBA));
    }

    public Number getThreshold() {
        Object threshold = this.getObject("threshold");
        if (Objects.equals(THRESHOLD_AUTO, threshold)) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"threshold") + "' must be set to a numeric value");
        }
        return this.getNumber("threshold");
    }
}

