/*
 * Decompiled with CFR 0.152.
 */
package sklearn.naive_bayes;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.python.HasArray;
import sklearn.naive_bayes.DiscreteNB;
import sklearn.naive_bayes.DiscreteNBUtil;

public class CategoricalNB
extends DiscreteNB {
    public CategoricalNB(String module, String name) {
        super(module, name);
    }

    @Override
    public BayesInputs encodeBayesInputs(List<?> values, List<? extends Feature> features) {
        Number alpha = this.getAlpha();
        List<HasArray> categoryCount = this.getCategoryCount();
        List<Integer> numberOfCategories = this.getNumberOfCategories();
        BayesInputs bayesInputs = new BayesInputs();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            int numberOfFeatureCategories = numberOfCategories.get(i);
            CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
            SchemaUtil.checkSize((int)numberOfFeatureCategories, (CategoricalFeature)categoricalFeature);
            HasArray featureCategoryCount = categoryCount.get(i);
            ArrayList<PairCounts> pairCounts = new ArrayList<PairCounts>();
            for (int j = 0; j < numberOfFeatureCategories; ++j) {
                List featureValueCounts = CMatrixUtil.getColumn((List)featureCategoryCount.getArrayContent(), (int)values.size(), (int)numberOfFeatureCategories, (int)j);
                pairCounts.add(DiscreteNBUtil.encodePairCounts(categoricalFeature.getValue(j), values, alpha, featureValueCounts));
            }
            BayesInput bayesInput = new BayesInput(categoricalFeature.getName(), null, pairCounts);
            bayesInputs.addBayesInputs(new BayesInput[]{bayesInput});
        }
        return bayesInputs;
    }

    public List<HasArray> getCategoryCount() {
        return this.getArrayList("category_count_");
    }

    public List<Integer> getNumberOfCategories() {
        return this.getIntegerArray("n_categories_");
    }
}

