/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decorable;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.preprocessing.OrdinalFeature;

public class EncoderUtil {
    private EncoderUtil() {
    }

    public static void addDecorator(Feature feature, Decorator decorator) {
        EncoderUtil.addDecorator(feature.getField(), decorator, (ModelEncoder)feature.getEncoder());
    }

    public static void addDecorator(Field<?> field, Decorator decorator, ModelEncoder encoder) {
        if (field instanceof Decorable) {
            encoder.addDecorator(field, decorator);
        } else if (!(field instanceof DerivedField)) {
            throw new IllegalArgumentException();
        }
    }

    public static Feature encodeRegroupFeature(Transformer transformer, Feature feature, List<?> oldCategories, Object newCategory, SkLearnEncoder encoder) {
        FieldRef fieldRef = feature.ref();
        DataType dataType = feature.getDataType();
        Apply apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createValueApply((Expression)fieldRef, (DataType)dataType, oldCategories), ExpressionUtil.createConstant((DataType)dataType, (Object)newCategory), fieldRef});
        DerivedField derivedField = encoder.createDerivedField(transformer.createFieldName("regroup", feature), OpType.CATEGORICAL, dataType, (Expression)apply);
        return FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder);
    }

    public static Feature encodeIndexFeature(Transformer transformer, Feature feature, List<?> categories, Number mapMissingTo, Number defaultValue, DataType dataType, SkLearnEncoder encoder) {
        ArrayList<Number> indexCategories = new ArrayList<Number>(categories.size());
        block5: for (int i = 0; i < categories.size(); ++i) {
            switch (dataType) {
                case INTEGER: {
                    indexCategories.add(i);
                    continue block5;
                }
                case FLOAT: {
                    indexCategories.add(Float.valueOf(i));
                    continue block5;
                }
                case DOUBLE: {
                    indexCategories.add(Double.valueOf(i));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return EncoderUtil.encodeIndexFeature(transformer, feature, categories, indexCategories, mapMissingTo, defaultValue, dataType, encoder);
    }

    public static Feature encodeIndexFeature(Transformer transformer, Feature feature, List<?> categories, List<? extends Number> indexCategories, Number mapMissingTo, Number defaultValue, DataType dataType, SkLearnEncoder encoder) {
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, indexCategories});
        MapValues mapValues = ExpressionUtil.createMapValues((String)feature.getName(), categories, indexCategories).setMapMissingTo((Object)mapMissingTo).setDefaultValue((Object)defaultValue);
        DerivedField derivedField = encoder.createDerivedField(transformer.createFieldName("encoder", feature), OpType.CATEGORICAL, dataType, (Expression)mapValues);
        final IndexFeature encodedFeature = new IndexFeature((PMMLEncoder)encoder, (Field)derivedField, indexCategories);
        OrdinalFeature result = new OrdinalFeature((PMMLEncoder)encoder, feature, categories){

            @Override
            public IndexFeature getEncodedFeature() {
                return encodedFeature;
            }
        };
        return result;
    }

    public static <E> List<E> filterCategories(List<E> categories) {
        return categories.stream().filter(category -> !EncoderUtil.isMissingCategory(category)).collect(Collectors.toList());
    }

    public static boolean isMissingCategory(Object category) {
        return category == null || ValueUtil.isNaN((Object)category);
    }
}

