/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class AggregateTransformer
extends Transformer {
    private static final String FUNCTION_AVG = "avg";
    private static final String FUNCTION_MAX = "max";
    private static final String FUNCTION_MEAN = "mean";
    private static final String FUNCTION_MIN = "min";
    private static final String FUNCTION_PROD = "prod";
    private static final String FUNCTION_PRODUCT = "product";
    private static final String FUNCTION_SUM = "sum";

    public AggregateTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return -1;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String function = this.getFunction();
        if (features.size() <= 1) {
            return features;
        }
        Apply apply = ExpressionUtil.createApply((String)AggregateTransformer.translateFunction(function), (Expression[])new Expression[0]);
        for (Feature feature : features) {
            apply.addExpressions(new Expression[]{feature.ref()});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName(function, features), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public String getFunction() {
        return (String)this.getEnum("function", arg_0 -> ((AggregateTransformer)this).getString(arg_0), Arrays.asList(FUNCTION_AVG, FUNCTION_MAX, FUNCTION_MEAN, FUNCTION_MIN, FUNCTION_PROD, FUNCTION_PRODUCT, FUNCTION_SUM));
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "avg": 
            case "mean": {
                return FUNCTION_AVG;
            }
            case "max": {
                return FUNCTION_MAX;
            }
            case "min": {
                return FUNCTION_MIN;
            }
            case "prod": 
            case "product": {
                return FUNCTION_PRODUCT;
            }
            case "sum": {
                return FUNCTION_SUM;
            }
        }
        throw new IllegalArgumentException(function);
    }
}

