/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.python.RegExFlavour;
import sklearn.Transformer;

public abstract class RegExTransformer
extends Transformer {
    protected static final String RE_FLAVOUR_PCRE = "pcre";
    protected static final String RE_FLAVOUR_PCRE2 = "pcre2";
    protected static final String RE_FLAVOUR_RE = "re";

    public RegExTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    public String getPattern() {
        return this.getString("pattern");
    }

    RegExTransformer setPattern(String pattern) {
        this.setattr("pattern", pattern);
        return this;
    }

    public String getReFlavour() {
        return (String)this.getOptionalEnum("re_flavour", arg_0 -> ((RegExTransformer)this).getOptionalString(arg_0), Arrays.asList(RE_FLAVOUR_PCRE, RE_FLAVOUR_PCRE2, RE_FLAVOUR_RE));
    }

    RegExTransformer setReFlavour(String reFlavour) {
        this.setattr("re_flavour", reFlavour);
        return this;
    }

    protected static RegExFlavour parseReFlavour(String reFlavour) {
        if (reFlavour == null) {
            return null;
        }
        switch (reFlavour) {
            case "pcre": {
                return RegExFlavour.PCRE;
            }
            case "pcre2": {
                return RegExFlavour.PCRE2;
            }
            case "re": {
                return RegExFlavour.RE;
            }
        }
        throw new IllegalArgumentException(reFlavour);
    }

    protected static String formatArg(String string) {
        return "\"" + string + "\"";
    }
}

