/*
 * Decompiled with CFR 0.152.
 */
package sklearn_pandas;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.razorvine.pickle.objects.ClassDict;
import org.jpmml.converter.Feature;
import org.jpmml.python.AttributeException;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.PythonFormatterUtil;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;
import sklearn.InitializerUtil;
import sklearn.Transformer;
import sklearn_pandas.TransformerPipeline;

public class DataFrameMapper
extends Initializer {
    public DataFrameMapper(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        return this.encodeFeatures(Collections.emptyList(), encoder);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean _default = this.getDefault();
        List<Object[]> rows = this.getFeatures();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Object[] row : rows) {
            Map options;
            String alias;
            List<String> columns = DataFrameMapper.getColumnList(row);
            List<Transformer> transformers = DataFrameMapper.getTransformerList(row);
            List<Feature> rowFeatures = InitializerUtil.selectFeatures(columns, features, encoder);
            for (Transformer transformer : transformers) {
                rowFeatures = transformer.encode(rowFeatures, encoder);
            }
            if (row.length > 2 && (alias = (String)(options = (Map)row[2]).get("alias")) != null) {
                for (int i = 0; i < rowFeatures.size(); ++i) {
                    Feature rowFeature = rowFeatures.get(i);
                    encoder.renameFeature(rowFeature, (String)(rowFeatures.size() > 1 ? alias + "_" + i : alias));
                }
            }
            result.addAll(rowFeatures);
        }
        return result;
    }

    public Boolean getDefault() {
        Object object = this.getOptionalObject("default");
        if (!Objects.equals(Boolean.FALSE, object)) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"default") + "' must be set to the " + PythonFormatterUtil.formatValue((Object)Boolean.FALSE) + " value");
        }
        return (Boolean)object;
    }

    public DataFrameMapper setDefault(Object _default) {
        this.setattr("default", _default);
        return this;
    }

    public List<Object[]> getFeatures() {
        return this.getTupleList("features");
    }

    public DataFrameMapper setFeatures(List<Object[]> features) {
        this.setattr("features", features);
        return this;
    }

    private static List<String> getColumnList(Object[] feature) {
        Object key = feature[0];
        if (key instanceof HasArray) {
            HasArray hasArray = (HasArray)key;
            key = hasArray.getArrayContent();
        }
        CastFunction<String> castFunction = new CastFunction<String>(String.class){

            protected String formatMessage(Object object) {
                return "The key object (" + ClassDictUtil.formatClass((Object)object) + ") is not a String";
            }
        };
        if (key instanceof List) {
            return Lists.transform((List)((List)key), (Function)castFunction);
        }
        return Collections.singletonList((String)castFunction.apply(key));
    }

    private static List<Transformer> getTransformerList(Object[] feature) {
        Object value = feature[1];
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof TransformerPipeline) {
            TransformerPipeline transformerPipeline = (TransformerPipeline)value;
            List<Object[]> steps = transformerPipeline.getSteps();
            value = TupleUtil.extractElementList(steps, (int)1);
        }
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            protected String formatMessage(Object object) {
                return "The value object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        if (value instanceof List) {
            return Lists.transform((List)((List)value), (Function)castFunction);
        }
        return Collections.singletonList((Transformer)castFunction.apply(value));
    }
}

