/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import net.razorvine.serpent.ParseException;

public class SeekableStringReader {
    private String str;
    private int cursor = 0;
    private int bookmark = -1;

    public SeekableStringReader(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str may not be null");
        }
        this.str = str;
    }

    public SeekableStringReader(SeekableStringReader parent) {
        this.str = parent.str;
        this.cursor = parent.cursor;
    }

    public boolean hasMore() {
        return this.cursor < this.str.length();
    }

    public char peek() {
        return this.str.charAt(this.cursor);
    }

    public String peek(int count) {
        return this.str.substring(this.cursor, this.cursor + Math.min(count, this.str.length() - this.cursor));
    }

    public char read() {
        return this.str.charAt(this.cursor++);
    }

    public String read(int count) {
        if (count < 0) {
            throw new ParseException("use Rewind to seek back");
        }
        int safecount = Math.min(count, this.str.length() - this.cursor);
        if (safecount == 0 && count > 0) {
            throw new ParseException("no more data");
        }
        String result = this.str.substring(this.cursor, this.cursor + safecount);
        this.cursor += safecount;
        return result;
    }

    public String readUntil(char sentinel) {
        int i = this.str.indexOf(sentinel, this.cursor);
        if (i >= 0) {
            int from = this.cursor;
            this.cursor = i + 1;
            return this.str.substring(from, i);
        }
        throw new ParseException("terminator not found");
    }

    public String readUntil(String sentinels) {
        int index = Integer.MAX_VALUE;
        for (char s : sentinels.toCharArray()) {
            int i = this.str.indexOf(s, this.cursor);
            if (i < 0) continue;
            index = Math.min(i, index);
        }
        if (index >= 0 && index < Integer.MAX_VALUE) {
            String result = this.str.substring(this.cursor, index);
            this.cursor = index + 1;
            return result;
        }
        throw new ParseException("terminator not found");
    }

    public String readWhile(String accepted) {
        int start = this.cursor;
        while (this.cursor < this.str.length() && accepted.indexOf(this.str.charAt(this.cursor)) >= 0) {
            ++this.cursor;
        }
        return this.str.substring(start, this.cursor);
    }

    public void skipWhitespace() {
        while (this.hasMore()) {
            char c = this.read();
            if (c == '#') {
                this.readUntil('\n');
                return;
            }
            if (Character.isWhitespace(c)) continue;
            this.rewind(1);
            return;
        }
    }

    public String rest() {
        if (this.cursor >= this.str.length()) {
            throw new ParseException("no more data");
        }
        String result = this.str.substring(this.cursor);
        this.cursor = this.str.length();
        return result;
    }

    public void rewind(int count) {
        this.cursor = Math.max(0, this.cursor - count);
    }

    public int bookmark() {
        return this.cursor;
    }

    public void flipBack(int bookmark) {
        this.cursor = bookmark;
    }

    public void sync(SeekableStringReader inner) {
        this.bookmark = inner.bookmark;
        this.cursor = inner.cursor;
    }

    public StringContext context(int crsr, int width) {
        if (crsr < 0) {
            crsr = this.cursor;
        }
        int leftStrt = Math.max(0, crsr - width);
        int leftLen = crsr - leftStrt;
        int rightLen = Math.min(width, this.str.length() - crsr);
        StringContext result = new StringContext();
        result.left = this.str.substring(leftStrt, leftStrt + leftLen);
        result.right = this.str.substring(crsr, crsr + rightLen);
        return result;
    }

    public void close() {
        this.str = null;
    }

    public class StringContext {
        public String left;
        public String right;
    }
}

