/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import java.lang.constant.Constable;
import java.util.LinkedHashMap;
import java.util.Map;
import lightgbm.sklearn.Booster;
import lightgbm.sklearn.HasBooster;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.HasLightGBMOptions;
import org.jpmml.lightgbm.ObjectiveFunction;
import sklearn.Estimator;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator> int getNumberOfFeatures(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        String[] featureNames = gbdt.getFeatureNames();
        return featureNames.length;
    }

    public static <E extends Estimator> ObjectiveFunction getObjectiveFunction(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        return gbdt.getObjectiveFunction();
    }

    public static <E extends Estimator & HasLightGBMOptions> MiningModel encodeModel(E estimator, Schema schema) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        ModelEncoder encoder = schema.getEncoder();
        Map<String, ?> options = BoosterUtil.getOptions(gbdt, estimator);
        Integer numIterations = (Integer)options.get("num_iteration");
        MiningModel miningModel = gbdt.encodeModel(numIterations, schema);
        encoder.transferFeatureImportances(null, (Model)miningModel);
        return miningModel;
    }

    public static <E extends Estimator & HasLightGBMOptions> Schema configureSchema(E estimator, Schema schema) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Map<String, ?> options = BoosterUtil.getOptions(gbdt, estimator);
        Schema lgbmSchema = gbdt.toLightGBMSchema(schema);
        lgbmSchema = gbdt.configureSchema(options, lgbmSchema);
        return lgbmSchema;
    }

    public static <E extends Estimator & HasLightGBMOptions> MiningModel configureModel(E estimator, MiningModel miningModel) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Map<String, ?> options = BoosterUtil.getOptions(gbdt, estimator);
        miningModel = gbdt.configureModel(options, miningModel);
        return miningModel;
    }

    public static PMML encodePMML(Booster booster) {
        GBDT gbdt = booster.getGBDT();
        Map<String, ?> options = BoosterUtil.getOptions(gbdt);
        return gbdt.encodePMML(options, null, null);
    }

    public static <E extends Estimator & HasLightGBMOptions> PMML encodePMML(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Map<String, ?> options = BoosterUtil.getOptions(gbdt, estimator);
        return gbdt.encodePMML(options, null, null);
    }

    private static GBDT getGBDT(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getGBDT();
    }

    private static Map<String, ?> getOptions(GBDT gbdt) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        Boolean nanAsMissing = Boolean.TRUE;
        result.put("nan_as_missing", nanAsMissing);
        return result;
    }

    private static <E extends Estimator & HasLightGBMOptions> Map<String, ?> getOptions(GBDT gbdt, E estimator) {
        LinkedHashMap<String, Constable> result = new LinkedHashMap<String, Constable>();
        Integer bestIteration = (Integer)estimator.getOptionalScalar("best_iteration_");
        Integer numIteration = (Integer)estimator.getOption("num_iteration", (Object)bestIteration);
        result.put("num_iteration", numIteration);
        Boolean nanAsMissing = (Boolean)estimator.getOption("nan_as_missing", (Object)Boolean.TRUE);
        result.put("nan_as_missing", nanAsMissing);
        Boolean compact = (Boolean)estimator.getOption("compact", (Object)Boolean.TRUE);
        result.put("compact", compact);
        return result;
    }
}

