/*
 * Decompiled with CFR 0.152.
 */
package water.logging;

import water.logging.ConsoleLogger;
import water.logging.Logger;
import water.logging.Slf4JLogger;

public class LoggerFactory {
    private static final String DEFAULT_SLF4J_CLASS_TO_CHECK = "org.slf4j.LoggerFactory";
    private static final String DEFAULT_WATERLOG_CLASS_TO_CHECK = "water.util.Log";
    private static final LoggerFactory INSTANCE = new LoggerFactory("org.slf4j.LoggerFactory", "water.util.Log");
    private final String slf4jClassName;
    private final boolean isSlf4JAvailable;
    private final String waterLogClassName;
    private final boolean isWaterLogAvailable;
    private final Logger waterLogger;

    LoggerFactory(String slf4jClass, String waterLogClass) {
        this.slf4jClassName = slf4jClass;
        this.waterLogClassName = waterLogClass;
        this.isSlf4JAvailable = this.isSlf4JAvailable();
        this.isWaterLogAvailable = this.isWaterLogAvailable();
        this.waterLogger = this.isWaterLogAvailable ? this.tryToGetWaterLogger() : null;
    }

    public static Logger getLogger(Class<?> clazz) {
        return INSTANCE.getCustomLogger(clazz);
    }

    public Logger getCustomLogger(Class<?> clazz) {
        if (this.isWaterLogAvailable && this.waterLogger != null) {
            return this.waterLogger;
        }
        if (this.isSlf4JAvailable) {
            return new Slf4JLogger(clazz);
        }
        return new ConsoleLogger();
    }

    private Logger tryToGetWaterLogger() {
        try {
            return (Logger)Class.forName("water.util.WaterLogger").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private boolean isSlf4JAvailable() {
        try {
            Class.forName(this.slf4jClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isWaterLogAvailable() {
        try {
            Class.forName(this.waterLogClassName);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

