/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.coxph;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.coxph.CoxPHMojoModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class CoxPHMojoReader
extends ModelMojoReader<CoxPHMojoModel> {
    @Override
    public String getModelName() {
        return "CoxPH";
    }

    @Override
    protected void readModelData() throws IOException {
        ((CoxPHMojoModel)this._model)._x_mean_cat = this.readRectangularDoubleArray("x_mean_cat");
        ((CoxPHMojoModel)this._model)._x_mean_num = this.readRectangularDoubleArray("x_mean_num");
        ((CoxPHMojoModel)this._model)._coef = (double[])this.readkv("coef");
        ((CoxPHMojoModel)this._model)._strata = this.readStrata();
        ((CoxPHMojoModel)this._model)._strata_len = this.readStrataLen();
        ((CoxPHMojoModel)this._model)._cat_offsets = (int[])this.readkv("cat_offsets");
        ((CoxPHMojoModel)this._model)._cats = (Integer)this.readkv("cats");
        ((CoxPHMojoModel)this._model)._useAllFactorLevels = (Boolean)this.readkv("use_all_factor_levels");
        ((CoxPHMojoModel)this._model)._lpBase = ((CoxPHMojoModel)this._model).computeLpBase();
        ((CoxPHMojoModel)this._model)._interaction_targets = (int[])this.readkv("interaction_targets");
        ((CoxPHMojoModel)this._model)._interaction_column_index = new HashSet();
        ((CoxPHMojoModel)this._model)._interaction_column_domains = new HashMap();
        ((CoxPHMojoModel)this._model)._nums = (Integer)this.readkv("num_numerical_columns");
        ((CoxPHMojoModel)this._model)._num_offsets = (int[])this.readkv("num_offsets");
        if (((CoxPHMojoModel)this._model)._interaction_targets != null) {
            ((CoxPHMojoModel)this._model)._interactions_1 = (int[])this.readkv("interactions_1");
            ((CoxPHMojoModel)this._model)._interactions_2 = (int[])this.readkv("interactions_2");
            for (int index : ((CoxPHMojoModel)this._model)._interaction_targets) {
                ((CoxPHMojoModel)this._model)._interaction_column_index.add(index);
                if (((CoxPHMojoModel)this._model)._domains[index] == null) continue;
                ((CoxPHMojoModel)this._model)._interaction_column_domains.put(index, Arrays.asList(((CoxPHMojoModel)this._model)._domains[index]));
            }
            this.createInteractionTypes();
        }
    }

    private void createInteractionTypes() {
        int numInteractions = ((CoxPHMojoModel)this._model)._interaction_targets.length;
        ((CoxPHMojoModel)this._model)._interaction_types = new CoxPHMojoModel.InteractionTypes[numInteractions];
        ((CoxPHMojoModel)this._model)._is_enum_1 = new boolean[numInteractions];
        for (int index = 0; index < numInteractions; ++index) {
            if (((CoxPHMojoModel)this._model)._domains[((CoxPHMojoModel)this._model)._interactions_1[index]] != null && ((CoxPHMojoModel)this._model)._domains[((CoxPHMojoModel)this._model)._interactions_2[index]] != null) {
                ((CoxPHMojoModel)this._model)._interaction_types[index] = CoxPHMojoModel.InteractionTypes.ENUM_TO_ENUM;
                ((CoxPHMojoModel)this._model)._is_enum_1[index] = true;
                continue;
            }
            if (((CoxPHMojoModel)this._model)._domains[((CoxPHMojoModel)this._model)._interactions_1[index]] == null && ((CoxPHMojoModel)this._model)._domains[((CoxPHMojoModel)this._model)._interactions_2[index]] == null) {
                ((CoxPHMojoModel)this._model)._interaction_types[index] = CoxPHMojoModel.InteractionTypes.NUM_TO_NUM;
                continue;
            }
            ((CoxPHMojoModel)this._model)._interaction_types[index] = CoxPHMojoModel.InteractionTypes.ENUM_TO_NUM;
            if (((CoxPHMojoModel)this._model)._domains[((CoxPHMojoModel)this._model)._interactions_1[index]] == null) continue;
            ((CoxPHMojoModel)this._model)._is_enum_1[index] = true;
        }
    }

    private HashMap<CoxPHMojoModel.Strata, Integer> readStrata() {
        int count = (Integer)this.readkv("strata_count");
        HashMap<CoxPHMojoModel.Strata, Integer> result = new HashMap<CoxPHMojoModel.Strata, Integer>(count);
        for (int i = 0; i < count; ++i) {
            double[] strata = (double[])this.readkv("strata_" + i);
            result.put(new CoxPHMojoModel.Strata(strata, strata.length), i);
        }
        return result;
    }

    private int readStrataLen() {
        int count = (Integer)this.readkv("strata_count");
        if (0 == count) {
            return 0;
        }
        double[] strata = (double[])this.readkv("strata_0");
        return strata.length;
    }

    @Override
    protected CoxPHMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new CoxPHMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

