/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.utils.DistributionFamily;

public class GamMojoMultinomialModel
extends GamMojoModelBase {
    private boolean _trueMultinomial;

    GamMojoMultinomialModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        super.init();
        this._trueMultinomial = this._family.equals((Object)DistributionFamily.multinomial);
    }

    @Override
    double[] gamScore0(double[] row, double[] preds) {
        this._beta_multinomial = row.length == this.nfeatures() ? this._beta_multinomial_center : this._beta_multinomial_no_center;
        for (int c = 0; c < this._nclasses; ++c) {
            preds[c + 1] = this.generateEta(this._beta_multinomial[c], row);
        }
        if (this._trueMultinomial) {
            return this.postPredMultinomial(preds);
        }
        return this.postPredOrdinal(preds);
    }

    double[] postPredMultinomial(double[] preds) {
        int c;
        double max_row = 0.0;
        double sum_exp = 0.0;
        for (c = 1; c < preds.length; ++c) {
            if (!(preds[c] > max_row)) continue;
            max_row = preds[c];
        }
        for (c = 1; c < preds.length; ++c) {
            preds[c] = Math.exp(preds[c] - max_row);
            sum_exp += preds[c];
        }
        sum_exp = 1.0 / sum_exp;
        double max_p = 0.0;
        for (int c2 = 1; c2 < preds.length; ++c2) {
            int n = c2;
            double d = preds[n] = preds[n] * sum_exp;
            if (!(d > max_p)) continue;
            max_p = preds[c2];
            preds[0] = c2 - 1;
        }
        return preds;
    }

    double[] postPredOrdinal(double[] preds) {
        int cInd;
        double previousCDF = 0.0;
        preds[0] = this._lastClass;
        for (cInd = 0; cInd < this._lastClass; ++cInd) {
            double eta = preds[cInd + 1];
            double currCDF = 1.0 / (1.0 + Math.exp(-eta));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
            if (!(eta > 0.0)) continue;
            preds[0] = cInd;
            break;
        }
        for (cInd = (int)preds[0] + 1; cInd < this._lastClass; ++cInd) {
            double currCDF = 1.0 / (1.0 + Math.exp(-preds[cInd + 1]));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
        }
        preds[this._nclasses] = 1.0 - previousCDF;
        return preds;
    }
}

