/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.MathUtils;
import java.util.Random;

public enum GlrmRegularizer {
    None{

        @Override
        public double regularize(double[] u) {
            return 0.0;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            return u;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u;
        }
    }
    ,
    Quadratic{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u) {
                ureg += ui * ui;
            }
            return ureg;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            double f = 1.0 / (1.0 + 2.0 * delta);
            for (int i = 0; i < u.length; ++i) {
                v[i] = u[i] * f;
            }
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u;
        }
    }
    ,
    L2{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u) {
                ureg += ui * ui;
            }
            return Math.sqrt(ureg);
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            double weight = 1.0 - delta / ArrayUtils.l2norm(u);
            if (weight < 0.0) {
                return v;
            }
            for (int i = 0; i < u.length; ++i) {
                v[i] = weight * u[i];
            }
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u;
        }
    }
    ,
    L1{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (double ui : u) {
                ureg += Math.abs(ui);
            }
            return ureg;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            for (int i = 0; i < u.length; ++i) {
                v[i] = Math.max(u[i] - delta, 0.0) + Math.min(u[i] + delta, 0.0);
            }
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u;
        }
    }
    ,
    NonNegative{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            for (double ui : u) {
                if (!(ui < 0.0)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            for (int i = 0; i < u.length; ++i) {
                v[i] = Math.max(u[i], 0.0);
            }
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u == null ? null : this.rproxgrad(u, 1.0, rand);
        }
    }
    ,
    OneSparse{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            int card = 0;
            for (double ui : u) {
                if (ui < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                if (!(ui > 0.0)) continue;
                ++card;
            }
            return card == 1 ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            int idx = ArrayUtils.maxIndex(u, rand);
            double d = u[idx] > 0.0 ? u[idx] : 1.0E-6;
            v[idx] = d;
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u == null ? null : this.rproxgrad(u, 1.0, rand);
        }
    }
    ,
    UnitOneSparse{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            int ones = 0;
            int zeros = 0;
            for (double ui : u) {
                if (ui == 1.0) {
                    ++ones;
                    continue;
                }
                if (ui == 0.0) {
                    ++zeros;
                    continue;
                }
                return Double.POSITIVE_INFINITY;
            }
            return ones == 1 && zeros == u.length - 1 ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            int idx = ArrayUtils.maxIndex(u, rand);
            v[idx] = 1.0;
            return v;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            return u == null ? null : this.rproxgrad(u, 1.0, rand);
        }
    }
    ,
    Simplex{

        @Override
        public double regularize(double[] u) {
            if (u == null) {
                return 0.0;
            }
            double sum = 0.0;
            double absum = 0.0;
            for (double ui : u) {
                if (ui < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                sum += ui;
                absum += Math.abs(ui);
            }
            return MathUtils.equalsWithinRecSumErr(sum, 1.0, u.length, absum) ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        public double[] rproxgrad(double[] u, double delta, Random rand) {
            if (u == null || delta == 0.0) {
                return u;
            }
            int n = u.length;
            int[] idxs = new int[n];
            for (int i = 0; i < n; ++i) {
                idxs[i] = i;
            }
            ArrayUtils.sort(idxs, u);
            double[] ucsum = new double[n];
            ucsum[n - 1] = u[idxs[n - 1]];
            for (int i = n - 2; i >= 0; --i) {
                ucsum[i] = ucsum[i + 1] + u[idxs[i]];
            }
            double t = (ucsum[0] - 1.0) / (double)n;
            for (int i = n - 1; i >= 1; --i) {
                double tmp = (ucsum[i] - 1.0) / (double)(n - i);
                if (!(tmp >= u[idxs[i - 1]])) continue;
                t = tmp;
                break;
            }
            double[] x = new double[u.length];
            for (int i = 0; i < u.length; ++i) {
                x[i] = Math.max(u[i] - t, 0.0);
            }
            return x;
        }

        @Override
        public double[] project(double[] u, Random rand) {
            double reg = this.regularize(u);
            if (reg == 0.0) {
                return u;
            }
            return this.rproxgrad(u, 1.0, rand);
        }
    };


    public abstract double regularize(double[] var1);

    public final double regularize(double[][] u) {
        if (u == null || this == None) {
            return 0.0;
        }
        double ureg = 0.0;
        for (double[] uarr : u) {
            if (Double.isInfinite(ureg += this.regularize(uarr))) break;
        }
        return ureg;
    }

    public abstract double[] rproxgrad(double[] var1, double var2, Random var4);

    public abstract double[] project(double[] var1, Random var2);
}

