
# {{ spec_id }} Testing Guide

## 1. Overview
- **Tech Spec**: {{ spec_id }} - {{ name }}
- **Purpose**: <Why this testing guide exists>
- **Test Owners**: <Teams/agents responsible>

## 2. Guidance & Conventions
- **Frameworks / Libraries**: <e.g. Go test, testify, cucumber>
- **Structure**: <Directory/package layout, naming conventions>
- **Factories & Helpers**: <List key fixtures/builders>
- **Mocking Strategy**: <Real infra vs in-memory vs fake services>

## 3. Strategy Matrix
| Scenario / Capability | Recommended Level | Rationale | Notes |
| --- | --- | --- | --- |
- Document how each behaviour ties to unit/component/integration/system tests.

## 4. Test Suite Inventory
For each suite/file:
- **Suite**: `path/to/test.go`
  - **Purpose**: <What it covers>
  - **Key Cases**:
    1. Description - Given/When/Then
    2. …
  - **Dependencies**: <Mocks, fixtures, infra requirements>

## 5. Regression & Edge Cases
- Enumerate regressions to guard against; specify dedicated tests.
- Highlight fragile areas needing extra assertions or property tests.

## 6. Infrastructure & Amenities
- How to run suites locally/in CI (commands, flags).
- Test data management (factories, seed data, snapshot practices).
- Known flakiness, mitigation steps, TODOs.

## 7. Coverage Expectations
- Target coverage (% or qualitative).
- Critical behaviours requiring exhaustive coverage.
- Observability hooks to verify during tests.

## 8. Backlog Hooks
- Outstanding test gaps (issue IDs, problem statements).
- Planned improvements to testing infrastructure.

## 9. Appendices (Optional)
- Advanced troubleshooting tips.
- Links to dashboards or CI job definitions.
