---
id: DE-002
slug: python-package-level-spec-granularity
name: Delta - Python package-level spec granularity
created: '2025-11-02'
updated: '2025-11-02'
status: completed
kind: delta
aliases: []
tags: ["AST", "python"]
relations:
  - type: satisfies
    target: PROD-005
    nature: Establishes Python package-level spec granularity pattern
applies_to:
  specs:
  - PROD-005
  requirements:
  - PROD-005.FR-001
  - PROD-005.FR-002
  - PROD-005.FR-003
  - PROD-005.FR-004
---

# DE-002 – Python package-level spec granularity

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-002
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - PROD-005
  collaborators: []
requirements:
  implements:
    - PROD-005.FR-001
    - PROD-005.FR-002
    - PROD-005.FR-003
    - PROD-005.FR-004
  updates: []
  verifies: []
phases:
  - IP-002.PHASE-01
  - IP-002.PHASE-02
  - IP-002.PHASE-03
```

## 1. Summary & Context

- **Product Spec(s)**: PROD-005 – Python Package-Level Specs (establishes leaf-package granularity pattern)
- **Technical Spec(s)**: None directly (impacts all future Python tech specs)
- **Implementation Plan**: [IP-002](./IP-002.md) – Not started
- **Change Drivers**:
  - Current state: 101 file-level placeholder specs (unsustainable maintenance)
  - Proven Go package-level pattern from vice
  - Need for practical, discoverable spec granularity

## 2. Motivation

The current file-level tech spec granularity (one spec per Python file) has created an unsustainable maintenance burden with 101 mostly-empty placeholder specs for ~108 implementation files. This approach:

- **Fragments design understanding**: Features spanning 5 files require navigating 5 separate specs
- **Resists refactoring**: File renames/moves break spec links and require spec updates
- **Provides noise not signal**: 99% placeholder content, minimal value
- **Misaligns with developer cognition**: Engineers reason about packages/modules, not individual files

The proven Go package-level approach from vice demonstrates that leaf-package granularity:
- Reduces spec count by 75% while maintaining traceability
- Groups cohesive functionality in single design documents
- Survives internal refactoring without spec maintenance
- Provides predictable automation without subjective decisions

**Supporting decisions**: PROD-005 establishes this pattern after evaluation of alternatives (capability-level, component-level, file-level).

## 3. Scope & Objectives

**Primary Outcomes**:
- Delete 101 existing file-level tech specs (SPEC-001 through SPEC-101)
- Generate ~25-30 leaf-package-level tech specs following Python package structure
- Update tooling to support package-level spec creation and querying (PROD-005.FR-003, FR-004)
- Validate deterministic contract generation across platforms (PROD-005.FR-002)
- Establish leaf-package identification logic (PROD-005.FR-001)

**Operational Constraints**:
- Solo developer project - manual migration acceptable
- One-time breaking change (all existing tech specs replaced)
- No backward compatibility needed (only user is maintainer)

**Dependencies**:
- Existing contract generation already implements deterministic ordering (`sorted()`)
- Registry sync mechanism must adapt to package-level indexing

## 4. Out of Scope

- **Opt-in rollup mechanism**: Deferred to future delta pending user demand
- **JS/TS granularity decision**: Separate evaluation needed for those languages
- **Migration tooling**: Manual cleanup sufficient for current scale
- **Backfilling tech spec content**: Focus on structure, not content population
- **Go spec migration**: Go already using package-level pattern in vice

## 5. Approach Overview

**System Touchpoints**:
- `supekku/scripts/lib/specs/` - spec creation logic
- `supekku/scripts/lib/specs/registry.py` - package indexing
- `supekku/cli/sync.py` - sync adapter for packages
- `supekku/scripts/lib/sync/adapters/python.py` - Python-specific sync logic
- `specify/tech/` - all existing tech specs (deletion + regeneration)

**Key Changes**:

1. **Package Detection Logic** (FR-001):
   - Implement leaf-package identification: directories with `__init__.py` and no child packages
   - Add validation: reject non-package paths, detect duplicate specs

2. **Spec Creation Enhancement** (FR-003):
   - Modify `create spec` to accept package paths
   - Generate frontmatter with package identifier vs file identifier
   - Prompt for package path or infer from context

3. **Query Resolution** (FR-004):
   - Implement file-to-package resolution: traverse up to find `__init__.py`
   - Update `--for-path` to resolve files to containing package spec
   - Add package path lookup in registry

4. **Validation** (FR-002):
   - Verify existing `sorted(path.rglob("*.py"))` produces deterministic output
   - Test across Linux/macOS platforms
   - Document stable ordering guarantee

**Migration / Rollout Notes**:
- Phase 01: Tooling updates and validation
- Phase 02: Manual cleanup (delete old specs, generate new)
- Phase 03: Documentation and verification
- No gradual rollout needed (breaking change acceptable)

## 6. Verification Strategy

**Requirements Coverage**:

- **PROD-005.FR-001** (Leaf Package Identification):
  - VT-001: Unit tests for package detection across directory structures
  - Test cases: leaf packages, nested packages, single-file packages, non-packages

- **PROD-005.FR-002** (Deterministic Ordering):
  - VT-002: Contract generation consistency test (10 runs, 2 platforms)
  - Verify byte-identical output for same package state

- **PROD-005.FR-003** (Sync Operation Support):
  - VT-003: Integration test with 5 package-level specs
  - Verify registry indexing, relationship tracking

- **PROD-005.FR-004** (File-to-Package Resolution):
  - VT-004: Query resolution tests at various directory depths
  - Edge cases: parent dirs, child packages, missing `__init__.py`

**Planned Artifacts**:
- VT-001, VT-002, VT-003, VT-004 (functional verification)
- VA-001 (git diff stability analysis)
- VA-002 (rollup extensibility design review)

**Acceptance Criteria**:
1. All 101 file-level specs deleted
2. ~25-30 package-level specs created with valid structure
3. `spec-driver sync` completes successfully
4. `spec-driver validate` passes
5. All VT artifacts show 100% pass rate
6. Contract regeneration produces zero spurious diffs

## 7. Risks & Mitigations

**RISK-001**: Registry has file-level indexing assumptions that break with packages
- **Likelihood**: Medium (registry designed for file-level)
- **Impact**: High (sync/query operations fail)
- **Mitigation**: Audit registry code in Phase 01, implement package indexing adapter

**RISK-002**: Existing PROD specs reference file-level tech specs
- **Likelihood**: Low (only 4 PROD specs exist)
- **Impact**: Medium (broken relationships)
- **Mitigation**: Update PROD spec relationships during Phase 02 cleanup

**RISK-003**: Contract generation assumes single file, breaks with packages
- **Likelihood**: Low (already handles directory input via `rglob()`)
- **Impact**: Medium (contract generation fails)
- **Mitigation**: Test Phase 01, confirm existing implementation handles packages

**RISK-004**: Deterministic ordering works differently on Windows
- **Likelihood**: Low (not currently supporting Windows)
- **Impact**: Low (future Windows users see spurious diffs)
- **Mitigation**: Document as known limitation; add Windows testing if demand arises

## 8. Follow-ups & Tracking

**Future Phases / Deltas**:
- **Rollup Mechanism** (deferred): Allow parent packages to cover child packages via config
- **JS/TS Granularity** (deferred): Evaluate appropriate pattern for JavaScript/TypeScript
- **Tech Spec Backfill** (future): Populate package-level specs with actual design content

**Backlog Items**:
- No new issues created (implementation straightforward)
- Potential future: ISSUE-XXX "Add Windows platform testing for contract stability"

**Open Decisions / Questions**:
- None remaining (all clarified during PROD-005 spec creation)

## 9. Implementation Notes

**Environment Setup**:
```bash
# Current directory structure
supekku/
├── cli/                    # → SPEC-XXX (one package spec)
├── scripts/
│   ├── lib/
│   │   ├── formatters/     # → SPEC-YYY (one package spec)
│   │   ├── changes/        # → SPEC-ZZZ (one package spec)
│   │   └── core/
│   │       └── frontmatter_metadata/  # → SPEC-AAA (leaf package)
```

**Key Commands**:
```bash
# Phase 01: Validate existing behavior
uv run pytest supekku/scripts/lib/docs/python/variants_test.py -v

# Phase 02: Clean migration
rm -rf specify/tech/SPEC-0*  # Delete all file-level specs
find supekku -type d -name __pycache__ -prune -o -type f -name __init__.py -print
# Manually create package-level spec for each package found

# Phase 03: Verify
uv run spec-driver sync
uv run spec-driver validate
```

**Code References**:
- Deterministic ordering: `supekku/scripts/lib/docs/python/variants.py:40-50`
- Registry implementation: `supekku/scripts/lib/specs/registry.py`
- Sync adapter: `supekku/scripts/lib/sync/adapters/python.py`

**Migration Time Estimate**: 2-4 hours total across all phases