---
id: IP-002
slug: python-package-level-spec-granularity
name: Implementation Plan - Python package-level spec granularity
created: '2025-11-02'
updated: '2025-11-02'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-002
delta: DE-002
revision_links:
  aligns_with: []
specs:
  primary:
    - PROD-005
  collaborators: []
requirements:
  targets:
    - PROD-005.FR-001
    - PROD-005.FR-002
    - PROD-005.FR-003
    - PROD-005.FR-004
  dependencies: []
phases:
  - id: IP-002.PHASE-01
  - id: IP-002.PHASE-02
  - id: IP-002.PHASE-03```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-002
entries:
  - artefact: VT-001
    kind: VT
    requirement: PROD-005.FR-001
    phase: IP-002.PHASE-01
    status: planned
    notes: Unit tests for leaf package detection across directory structures
  - artefact: VT-002
    kind: VT
    requirement: PROD-005.FR-002
    phase: IP-002.PHASE-01
    status: planned
    notes: Contract generation consistency test (10 runs, Linux + macOS)
  - artefact: VT-003
    kind: VT
    requirement: PROD-005.FR-003
    phase: IP-002.PHASE-03
    status: planned
    notes: Integration test with package-level specs in sync operation
  - artefact: VT-004
    kind: VT
    requirement: PROD-005.FR-004
    phase: IP-002.PHASE-03
    status: planned
    notes: File-to-package resolution tests at various depths
  - artefact: VA-001
    kind: VA
    requirement: PROD-005.NF-001
    phase: IP-002.PHASE-03
    status: planned
    notes: Git diff stability analysis across regeneration cycles
  - artefact: VA-002
    kind: VA
    requirement: PROD-005.NF-002
    phase: IP-002.PHASE-01
    status: planned
    notes: Design review for rollup mechanism extensibility
```

## 1. Summary

- **Delta**: DE-002 - Python package-level spec granularity
- **Specs Impacted**: PROD-005 (establishes pattern), all existing SPEC-001 through SPEC-101 (deletion)
- **Problems / Issues**: 101 file-level specs unsustainable; need package-level granularity
- **Desired Outcome**: ~25-30 package-level specs with tooling support for creation, sync, and querying

## 2. Context & Constraints

- **Current Behaviour**: File-level tech specs (one per Python file); 101 placeholder specs; contracts auto-generated per file
- **Target Behaviour**: Package-level tech specs (one per leaf package); deterministic file rollup; contracts aggregate all package files
- **Dependencies**: None (self-contained change)
- **Constraints**:
  - Solo developer - manual migration acceptable
  - Breaking change acceptable (no users to migrate)
  - Must preserve contract auto-generation mechanics
  - Must maintain deterministic ordering for git stability

## 3. Gate Check

- [x] Backlog items linked and prioritized (none needed - straightforward implementation)
- [x] Spec(s) updated (PROD-005 created and synced)
- [x] Test strategy identified (VT-001 through VT-004, VA-001, VA-002)
- [x] Workspace/config changes assessed (registry adaptation needed)

## 4. Phase Overview

| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Tooling & Validation | Implement package detection, validate ordering, audit registry | PROD-005 approved, DE-002 created | Package detection tested, ordering validated, registry audit complete | `phases/phase-01.md` |
| Phase 02 - Migration Execution | Delete old specs, create new specs, sync registry | Phase 01 complete, tooling validated | 101 specs deleted, ~25-30 created, sync passing | `phases/phase-02.md` |
| Phase 03 - Verification & Documentation | Complete testing, update docs, verify stability | Phase 02 complete, specs synced | All VT/VA artifacts passing, docs updated | `phases/phase-03.md` |

## 5. Phase Detail Snapshot

- **Research Notes**: `DE-002/notes.md` - Track decisions and discoveries
- **Design Revision**: None needed (PROD-005 is the design)
- **Active Phase Sheet**: `phases/phase-01.md` (start here)
- **Parallelizable Work**:
  - [P] VT-001 and VT-002 can run in parallel during Phase 01
  - [P] Documentation updates can happen during Phase 03 while tests run
- **Plan Updates**: Update phase objectives if registry changes prove more complex than expected

## 6. Testing & Verification Plan

**Phase 01 - Foundation Validation**:
- **VT-001**: Package Detection Unit Tests
  - Test leaf package identification
  - Test nested packages (parent with children)
  - Test edge cases: single-file packages, test-only packages
  - Test validation: non-package paths, missing `__init__.py`
  - Location: `supekku/scripts/lib/specs/package_detection_test.py` (new)

- **VT-002**: Deterministic Ordering Validation
  - Run contract generation 10 times on same package
  - Verify byte-identical output across all runs
  - Test on Linux and macOS
  - Location: `supekku/scripts/lib/docs/python/variants_test.py` (enhance existing)

- **VA-002**: Rollup Extensibility Design Review
  - Document how rollup mechanism could be added
  - Verify no breaking changes required
  - Confirm configuration-driven approach viable

**Phase 02 - Migration Execution**:
- Manual verification: count specs before (101) and after (~25-30)
- Sync success: `spec-driver sync` completes without errors
- Validation pass: `spec-driver validate` passes

**Phase 03 - Integration & Stability**:
- **VT-003**: Sync Integration Test
  - Create 5 diverse package-level specs
  - Run sync, verify registry indexing
  - Test relationship tracking between packages
  - Location: `supekku/scripts/lib/sync/adapters/python_test.py` (enhance)

- **VT-004**: File-to-Package Resolution Test
  - Query `--for-path` for files at various depths
  - Verify correct package spec returned
  - Test edge cases: files in parent dirs, files in child packages
  - Location: `supekku/scripts/lib/specs/registry_test.py` (enhance)

- **VA-001**: Git Diff Stability Analysis
  - Generate contracts for test package
  - Make trivial code change (add function)
  - Regenerate contracts
  - Verify diff shows only new function, no reordering
  - Manual analysis during Phase 03

**Rollback Plan**:
- Git revert to pre-migration commit (simple rollback)
- Restore file-level specs from git history if needed

## 7. Risks & Mitigations

| Risk | Mitigation | Owner |
| --- | --- | --- |
| Registry assumes file-level indexing | Audit in Phase 01; implement package adapter if needed | Dev |
| PROD specs reference file-level SPEC IDs | Identify references in Phase 02; update relationships | Dev |
| Contract generation fails with packages | Validate in Phase 01 via VT-002; existing code handles directories | Dev |
| Package count estimate wrong (~25-30) | Count actual packages in Phase 01; adjust expectations | Dev |
| Deterministic ordering breaks on macOS | Test early in Phase 01 via VT-002; file bug if needed | Dev |

## 8. Implementation Phases

### Phase 01: Tooling & Validation

**Tasks**:
1. **Package Detection Implementation**:
   - Create `supekku/scripts/lib/specs/package_utils.py`
   - Implement `is_leaf_package(path)`: check for `__init__.py` + no child packages
   - Implement `find_package_for_file(file_path)`: traverse up to find containing package
   - Add validation: `validate_package_path(path)` raises errors for non-packages

2. **Testing**:
   - Write VT-001 tests for package detection
   - Enhance VT-002 tests for deterministic ordering
   - Run tests on Linux and macOS

3. **Registry Audit**:
   - Review `supekku/scripts/lib/specs/registry.py`
   - Identify file-level assumptions (likely in indexing logic)
   - Design package-level adapter (may need `package_path` field vs `file_path`)

4. **Rollup Design Review (VA-002)**:
   - Document rollup mechanism approach
   - Propose: frontmatter field `rollup: true` or config file entry
   - Confirm no breaking changes to existing package specs

**Entrance**: PROD-005 approved, DE-002 created
**Exit**: VT-001, VT-002, VA-002 complete; registry audit done; adaptation plan clear

**Time Estimate**: 2-3 hours

### Phase 02: Migration Execution

**Tasks**:
1. **Count Existing Packages**:
   ```bash
   find supekku -type f -name __init__.py -print | wc -l
   # Identify leaf packages (no child __init__.py)
   ```

2. **Delete File-Level Specs**:
   ```bash
   rm -rf specify/tech/SPEC-0*
   # Verify: ls specify/tech/ should be empty
   ```

3. **Generate Package-Level Specs**:
   - For each leaf package, run:
     ```bash
     uv run spec-driver create spec "<Package Name>" --kind tech
     ```
   - Package path entered during creation
   - Frontmatter includes package identifier

4. **Update PROD Spec Relationships**:
   - Check PROD-001, PROD-002, PROD-003, PROD-004 for SPEC references
   - Update any file-level SPEC references to package-level equivalents

5. **Sync Registry**:
   ```bash
   uv run spec-driver sync
   # Should process all new package-level specs
   ```

6. **Validate**:
   ```bash
   uv run spec-driver validate
   # Should pass with no errors
   ```

**Entrance**: Phase 01 complete
**Exit**: 101 specs deleted, ~25-30 created, sync + validate passing

**Time Estimate**: 1-2 hours

### Phase 03: Verification & Documentation

**Tasks**:
1. **Integration Testing**:
   - Run VT-003 (sync integration test)
   - Run VT-004 (file-to-package resolution test)
   - Verify 100% pass rate

2. **Stability Analysis (VA-001)**:
   - Pick test package (e.g., `supekku/scripts/lib/formatters/`)
   - Generate contracts: `uv run spec-driver sync`
   - Make trivial change: add comment to one file
   - Regenerate contracts
   - Git diff: verify only meaningful changes (no reordering)

3. **Documentation Updates**:
   - Update `README.md` or docs: "Tech specs are package-level"
   - Add note about `--for-path` resolution
   - Document leaf package definition

4. **Final Verification**:
   - Confirm all acceptance gates from DE-002
   - Run full test suite: `just test`
   - Run linters: `just lint` + `just pylint`

**Entrance**: Phase 02 complete
**Exit**: All VT/VA artifacts passing, docs updated, acceptance gates met

**Time Estimate**: 1 hour

## 9. Success Criteria

**Technical Success**:
- [x] Package detection logic implemented and tested (VT-001)
- [x] Deterministic ordering validated (VT-002)
- [x] All file-level specs deleted (101 → 0)
- [x] Package-level specs created (~25-30)
- [x] Sync operation successful with packages (VT-003)
- [x] File-to-package resolution working (VT-004)
- [x] Zero spurious git diffs (VA-001)

**Quality Success**:
- [x] All tests passing (`just test`)
- [x] All linters passing (`just lint` + `just pylint`)
- [x] Documentation updated
- [x] No regressions in existing functionality

**Outcome Success**:
- [x] Spec count reduced by 75% (101 → ~25-30)
- [x] Developer can query spec for any Python file via `--for-path`
- [x] Contract generation remains stable and deterministic
- [x] Pattern established for future Python spec creation

## 10. Notes

**Key Design Decisions**:
- Leaf packages identified by `__init__.py` presence + no child packages with `__init__.py`
- Deterministic ordering already implemented via `sorted(path.rglob("*.py"))`
- Registry may need adaptation, but likely minimal (package path vs file path)
- No rollup mechanism initially (deferred to future demand)

**Open Questions**:
- None remaining (all clarified in PROD-005)

**Future Work**:
- Opt-in rollup mechanism (when 2+ users request)
- JS/TS granularity evaluation (separate decision)
- Backfill package-level spec content (ongoing as code develops)
