---
id: IP-003
slug: cli-integration-for-frontmatter-schema-show-commands
name: Implementation Plan - CLI Integration for Frontmatter Schema Show Commands
created: '2025-11-02'
updated: '2025-11-02'
status: completed
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-003
delta: DE-003
revision_links:
  aligns_with: []
specs:
  primary:
    - PROD-004
  collaborators: []
requirements:
  targets: []
  dependencies: []
phases:
  - id: IP-003.PHASE-01```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-003
entries:
  - artefact: VT-CLI-001
    kind: VT
    requirement: PROD-004.FR-004
    phase: IP-003.PHASE-01
    status: passed
    notes: CLI command integration tests - 23 tests passing including 8 new frontmatter tests
  - artefact: VT-CLI-002
    kind: VT
    requirement: PROD-004.FR-004
    phase: IP-003.PHASE-01
    status: passed
    notes: All 16 frontmatter kinds tested for json-schema and yaml-example formats
  - artefact: VT-CLI-003
    kind: VT
    requirement: PROD-004.NF-002
    phase: IP-003.PHASE-01
    status: passed
    notes: Schema generation <100ms, all CLI tests complete in <1s
```

## 1. Summary
- **Delta**: DE-003 - CLI Integration for Frontmatter Schema Show Commands
- **Specs Impacted**: PROD-004 (Frontmatter Metadata Validation)
- **Problems / Issues**: Agents lack schema documentation for writing valid frontmatter YAML
- **Desired Outcome**: All 16 frontmatter schemas accessible via CLI in JSON Schema and YAML example formats

## 2. Context & Constraints
- **Current Behaviour**: No CLI access to frontmatter schemas; agents must read Python code
- **Target Behaviour**: PROD-004.FR-004 - CLI supports `schema show frontmatter.{kind}` commands
- **Dependencies**: Frontmatter metadata migration complete (260 tests passing)
- **Constraints**: No breaking changes to existing CLI; fast execution (<100ms)

## 3. Gate Check
- [x] Backlog items linked and prioritised
- [x] Spec(s) updated or delta specifies required changes
- [x] Test strategy identified (unit/integration/system)
- [x] Workspace/config changes assessed


> Tip: Plan phases up front, then create the phase sheet for the current phase only. Update later phases when you are ready to execute them.

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Implementation | Extend schema.py to support frontmatter | Frontmatter metadata registry verified accessible | CLI commands working, tests passing, lint clean | `phases/phase-01.md` |

## 5. Phase Detail Snapshot
- **Research Notes**: `DE-003/notes.md`
- **Active Phase Sheet**: `phases/phase-01.md`
- **Implementation**: Single-phase delivery (no additional phases needed)

## 6. Testing & Verification Plan
- **Updated Suites**: `supekku/cli/schema_test.py` - added 8 new test methods
- **New Cases**:
  - List frontmatter schemas
  - Show frontmatter JSON Schema for all 16 kinds
  - Show frontmatter YAML examples for all 16 kinds
  - Error handling (unknown kinds, invalid formats)
- **Tooling/Fixtures**: Used existing CliRunner from typer.testing
- **Verification Coverage**: All VT artifacts passed (VT-CLI-001, VT-CLI-002, VT-CLI-003)

## 7. Risks & Mitigations
| Risk | Mitigation | Status |
| --- | --- | --- |
| Breaking existing CLI commands | Extended existing patterns, added tests for backward compatibility | ✅ Mitigated |
| JSON Schema output incompatibility | Followed JSON Schema Draft 2020-12, validated output | ✅ Mitigated |

## 8. Open Questions & Decisions
- [x] Command naming: Use `frontmatter.{kind}` format - DECIDED: Yes, follows common CLI patterns
- [x] Support markdown format for frontmatter? - DECIDED: No, only json-schema and yaml-example

## 9. Success Criteria
- [x] All 16 frontmatter kinds accessible via `spec-driver schema show frontmatter.{kind}`
- [x] JSON Schema output validates against JSON Schema Draft 2020-12
- [x] YAML examples validate against their corresponding JSON Schemas
- [x] Error messages guide users to correct syntax
- [x] Help text documents all available kinds and formats
- [x] Zero ruff warnings, pylint >9.0
- [x] All tests passing (78 CLI tests including 23 schema tests)

## 10. Progress Tracking
- [x] Phase 01 complete
- [x] Verification gates passed
- [x] All success criteria met

## 11. Implementation Notes

### Files Modified
- `supekku/cli/schema.py` - Added frontmatter support to existing schema commands
- `supekku/cli/schema_test.py` - Added 8 comprehensive test methods

### Key Changes
1. Extended `list` command to support `schema list frontmatter`
2. Extended `show` command to handle `frontmatter.{kind}` block types
3. Added `_show_frontmatter_schema()` function for frontmatter-specific handling
4. Added `_render_frontmatter_json_schema()` and `_render_frontmatter_yaml_example()` functions

### Test Results
- All 78 CLI tests passing
- Ruff: All checks passed (0 errors, 0 warnings)
- Pylint: 9.67/10 rating
- Schema generation: <100ms per requirement

## 12. Notes / Links
- Delta document: `DE-003.md`
- PROD spec: `specify/product/PROD-004/PROD-004.md`
- Frontmatter metadata registry: `supekku/scripts/lib/core/frontmatter_metadata/`
