---
id: IP-005
slug: implement-spec-backfill
name: Implementation Plan - implement spec backfill
created: '2025-11-02'
updated: '2025-11-02'
status: complete
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-005
delta: DE-005
revision_links:
  aligns_with: []
specs:
  primary:
    - PROD-007
  collaborators:
    - SPEC-110
    - SPEC-112
requirements:
  targets:
    - PROD-007.FR-001
    - PROD-007.FR-002
    - PROD-007.FR-005
    - PROD-007.FR-006
  dependencies: []
phases:
  - id: IP-005.PHASE-01```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-005
entries:
  - artefact: VT-004
    kind: VT
    requirement: PROD-007.FR-005
    phase: IP-005.PHASE-01
    status: passed
    notes: Stub detection correctly identifies stub vs modified specs (7 tests passing)
  - artefact: VT-005
    kind: VT
    requirement: PROD-007.FR-006
    phase: IP-005.PHASE-01
    status: passed
    notes: Template retrieval working for both product and tech specs (8 tests passing)
  - artefact: VT-001
    kind: VT
    requirement: PROD-007.FR-001
    phase: IP-005.PHASE-01
    status: passed
    notes: End-to-end single spec backfill workflow functional (SPEC-125, SPEC-110, CONTRACT_REVIEW)
```

## 1. Summary
- **Delta**: DE-005 - implement spec backfill
- **Specs Impacted**: PROD-007
- **Problems / Issues**: PROD-001/RISK-007 (no workflow for completing existing/incomplete specs)
- **Desired Outcome**: Agent-assisted workflow for completing stub specs, reducing completion time from 2+ hours to <10 minutes while maintaining quality

## 2. Context & Constraints
- **Current Behaviour**: After `spec-driver sync`, stub specs are generated but require manual YAML editing and completion (2+ hours per spec)
- **Target Behaviour**: PROD-007.FR-001 (agent workflow), FR-002 (preserve manual content), FR-005 (stub detection), FR-006 (template retrieval)
- **Dependencies**:
  - SpecRegistry working (confirmed: `supekku/scripts/lib/specs/registry.py`)
  - Template infrastructure (confirmed: `supekku/templates/spec.md` with Jinja2)
  - Contracts generation via sync (confirmed working)
- **Constraints**:
  - Phase 01: Single-spec only (batch mode deferred)
  - Must not overwrite manual content (data loss risk)
  - Zero breaking changes to existing CLI

## 3. Gate Check
- [x] Backlog items linked and prioritised (see phase-01.md tasks)
- [x] Spec(s) updated or delta specifies required changes (PROD-007 complete)
- [x] Test strategy identified (unit: per module, integration: end-to-end workflow)
- [x] Workspace/config changes assessed (no breaking changes, new CLI subcommand only)


> Tip: Plan phases up front, then create the phase sheet for the current phase only. Update later phases when you are ready to execute them.

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Core Implementation | Implement single-spec backfill: stub detection, CLI body replacement, agent workflow | PROD-007 validated, contracts working | stub detection tested, CLI backfill working, agent command functional, all tests+lints passing | `phases/phase-01.md` |
| Phase 02 - Batch Mode | Add batch processing for multiple specs | Phase 01 complete | Batch commands working, progress reporting, error isolation | TBD |

*Phase 01 is active. Batch mode (PROD-007.FR-003, FR-004) deferred to Phase 02.*

## 5. Phase Detail Snapshot
- **Research Notes**: Infrastructure validated - see Section 10 (Research Findings)
- **Design Revision**: See `REVISED-DESIGN.md` - simplified approach (CLI mechanics, agent intelligence)
- **Active Phase Sheet**: `phases/phase-01.md`
- **Parallelisable Work**: Tasks 1.2 and 1.4 can start in parallel (detection independent of CLI)
- **Plan Updates**:
  - Task 1.3 (completion module) removed - agent does intelligent completion
  - Task 1.4 simplified - CLI just replaces body with template
  - Phase 01 scoped to single-spec workflow; batch mode moved to Phase 02

## 6. Testing & Verification Plan
- **New Test Files**:
  - `supekku/cli/show_test.py` - Template retrieval tests (already complete)
  - `supekku/scripts/lib/specs/detection_test.py` - Stub detection tests
  - `supekku/cli/backfill_test.py` - CLI integration tests
- **Key Scenarios**:
  - VT-004: Stub detection with actual vs modified specs (status + line count)
  - VT-005: Template retrieval for both product and tech specs (already complete)
  - VT-001: End-to-end single spec backfill workflow (CLI + agent)
- **Tooling/Fixtures**: Stub spec fixtures, modified spec fixtures, template rendering helpers
- **Rollback Plan**: N/A (net-new commands, no breaking changes)
- **Verification Coverage**: VT-001, VT-004, VT-005 mapped to PROD-007 requirements (see delta)

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Stub detection false positives (data loss) | Status-based primary check; line count fallback (≤30); --force flag; comprehensive test suite | Dev |
| Template rendering varies by environment | Pin Jinja2 version; test with actual templates | Dev |
| CLI overwrites manual content accidentally | Stub detection with --force required; frontmatter preservation tests | Dev |

## 8. Open Questions & Decisions
- [x] CLI command naming: `backfill` chosen (vs `complete` or `fill`) - clearer intent
- [x] Stub detection approach: Status-based + line count fallback (vs template matching) - simpler, faster, safer
- [x] Batch mode scope: Deferred to Phase 02 - focus on single-spec first
- [x] Architecture: CLI does mechanics (body replacement), agent does intelligence (completion) - 2025-11-02
- [x] Task 1.3 removed: No programmatic completion module needed - 2025-11-02

## 9. Progress Tracking
- [x] Research complete (infrastructure validated)
- [x] Phase 01 in progress (see `phases/phase-01.md` for detailed task status)
- [ ] Phase 01 complete - Tasks 1.1-1.5.3 done, Task 1.6 (integration testing) remains
- [ ] Phase 02 planned (batch mode)
- [ ] Verification gates passed

### Phase 01 Status (2025-11-02)
**Completed Tasks**:
- ✅ 1.1: Show template command (8 tests passing)
- ✅ 1.2: Stub detection logic (7 tests passing)
- ✅ 1.4: CLI backfill command (2 tests passing, frontmatter fix applied)
- ✅ 1.5: Agent command (`.claude/commands/supekku.backfill.md` created)
- ✅ 1.5.1: Auto-created specs → status='stub' (sync_specs.py + orphan messages + --prune safety)
- ✅ 1.5.2: Migrated 16 existing stub specs (migrate_stub_status.py)
- ✅ 1.5.3: Status theming (stub=mid-grey, draft=light-grey)

**Remaining**: Task 1.6 (Integration testing & dogfooding)

**Issues Created**: ISSUE-009 (status enum validation)

## 10. Notes / Links

### Research Findings

**Infrastructure Validated**:
- Templates: `supekku/templates/spec.md` (Jinja2, unified for product/tech with conditionals)
  - Variables: `spec_id`, `name`, `kind`, `spec_relationships_block`, `spec_capabilities_block`, `spec_verification_block`
- SpecRegistry: `supekku/scripts/lib/specs/registry.py`
  - Methods: `reload()`, `get(spec_id)`, `all_specs()`, `find_by_package(package)`
  - Uses `load_validated_markdown_file()` from `core.spec_utils`
  - Returns `Spec` model with `id`, `path`, `frontmatter`, `body`
- CLI Pattern: Typer-based, thin orchestration (load → format → output)
  - Standard error handling with `EXIT_FAILURE` / `EXIT_SUCCESS`
  - `RootOption` for repo root override
- Agent Command Pattern: `.claude/commands/supekku.specify.md` provides template
  - Structured workflow, quality gates, `--json` output

**Contracts Location**: `specify/{kind}/{spec-id}/contracts/*.md`

### Supporting Docs
- PROD-007: Product spec with requirements
- DE-005: Delta document
- `.claude/commands/supekku.specify.md`: Similar agent workflow pattern
- `phases/phase-01.md`: Detailed task breakdown
