---
id: IP-006
slug: standardize-cli-json-output-support
name: Implementation Plan - Standardize CLI JSON output support
created: '2025-11-02'
updated: '2025-11-02'
status: complete
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-006
delta: DE-006
revision_links:
  aligns_with: []
specs:
  primary:
    - SPEC-003  # supekku/cli/create.py
    - SPEC-004  # supekku/cli/list.py
    - SPEC-006  # supekku/cli/show.py
  collaborators: []
requirements:
  targets: []
  dependencies: []
phases:
  - id: IP-006.PHASE-01```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-006
entries:
  - artefact: VT-CLI-JSON-001
    kind: VT
    requirement: DE-006.consistency
    phase: IP-006.PHASE-01
    status: verified
    notes: 3 JSON output tests in supekku/cli/create_test.py (test_create_issue_json_output, test_create_problem_json_output, test_create_risk_json_output)
  - artefact: VT-CLI-JSON-002
    kind: VT
    requirement: DE-006.agent-workflow
    phase: IP-006.PHASE-01
    status: verified
    notes: Verified via manual testing - create issue/problem/risk --json and list specs --json work correctly
  - artefact: VT-CLI-JSON-003
    kind: VT
    requirement: DE-006.backward-compat
    phase: IP-006.PHASE-01
    status: verified
    notes: All 69 CLI tests passing - existing text output unchanged when --json not specified
```

## 1. Summary

- **Delta**: DE-006 - Standardize CLI JSON output support
- **Specs Impacted**: SPEC-003 (create.py), SPEC-004 (list.py), SPEC-006 (show.py)
- **Problems / Issues**: ISSUE-007 (CLI commands missing --json output support)
- **Desired Outcome**: All create/list/show commands support consistent --json output for agent automation

## 2. Context & Constraints

**Current Behavior**:
- Only `create spec` command supports `--json` flag
- Other `create` subcommands (issue, problem, risk) fail with "--json: No such option"
- All `list` commands lack `--json` support
- `show` commands lack `--json` support
- Agents and automation scripts must parse brittle text output

**Target Behavior**:
- All `create` subcommands accept `--json` flag
- All `list` commands accept `--json` flag
- All `show` commands accept `--json` flag
- JSON output follows standard schema: `{"id": "...", "path": "...", "kind": "...", "status": "..."}`
- Default text output unchanged (backward compatibility)

**Dependencies**:
- None - standalone improvement

**Constraints**:
- Zero breaking changes to existing text output
- Must follow existing pattern from `create spec --json` (create.py:58-79)
- All existing tests must continue passing
- Single-phase implementation (straightforward additive change)

## 3. Gate Check

- [x] Backlog items linked (ISSUE-007)
- [x] Delta specifies required changes (DE-006.md sections 5.1-5.3)
- [x] Test strategy identified (unit tests per command + integration test)
- [x] Workspace/config changes assessed (none needed)

## 4. Phase Overview

| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Add --json support | Implement --json flag for all commands | Delta approved, pattern understood | All commands support --json, tests passing, lint passing | `phases/phase-01.md` |

*Single-phase plan: straightforward additive change following established pattern.*

## 5. Phase Detail Snapshot

- **Research Notes**: Not needed - pattern already established in create.py
- **Design Revision**: Not needed - following existing pattern
- **Active Phase Sheet**: `phases/phase-01.md`
- **Parallelizable Work**: Commands can be updated independently (mark with [P])
- **Plan Updates**: None expected - scope well-defined

## 6. Testing & Verification Plan

**Updated Suites**:
- `supekku/cli/create_test.py` - add JSON output tests for each subcommand
- `supekku/cli/list_test.py` - add JSON output tests (new file if needed)
- `supekku/cli/show_test.py` - add JSON output tests (new file if needed)

**New Test Cases**:

1. **create.py tests**:
   - Test `create issue --json` returns valid JSON with id, path, kind, status
   - Test `create problem --json` returns valid JSON
   - Test `create risk --json` returns valid JSON
   - Test default text output unchanged when --json not specified

2. **list.py tests**:
   - Test `list specs --json` returns `{"count": N, "items": [...]}`
   - Test `list issues --json` returns valid JSON array
   - Test `list deltas --json` returns valid JSON array
   - Test default text output unchanged

3. **show.py tests**:
   - Test `show spec SPEC-001 --json` returns valid JSON
   - Test default text output unchanged

4. **Integration test**:
   - End-to-end agent workflow: create artifact with --json, parse output, use in next command
   - Validates real-world automation use case

**Tooling/Fixtures**:
- Use `json.loads()` to validate JSON output in tests
- Capture stdout and assert JSON schema structure
- Existing fixtures for creating test artifacts

**Rollback Plan**:
- N/A - purely additive change, no rollback needed
- If issues arise, can revert individual command changes independently

**Verification Coverage**:
- VT-CLI-JSON-001: Unit tests per command
- VT-CLI-JSON-002: Integration test for agent workflow
- VT-CLI-JSON-003: Regression tests for text output

## 7. Risks & Mitigations

| Risk | Mitigation | Owner |
| --- | --- | --- |
| Breaking text output parsers | --json is opt-in; default unchanged | Dev |
| Inconsistent JSON schema | Define standard format in delta; follow strictly | Dev |
| Missing edge cases | Comprehensive test coverage; use json.dumps with default=str | Dev |
| JSON serialization errors | Test with real artifact data; handle Path objects with str() | Dev |

## 8. Open Questions & Decisions

- [x] Should we add --json to sync/validate commands? **Decision**: No - they don't return data
- [x] What JSON schema to use? **Decision**: `{"id": "...", "path": "...", "kind": "...", "status": "..."}` for single items; `{"count": N, "items": [...]}` for lists
- [x] Single phase or multi-phase? **Decision**: Single phase - straightforward implementation

## 9. Progress Tracking

- [ ] Phase 01 complete
  - [ ] Update create.py with --json for all subcommands
  - [ ] Update list.py with --json for all commands
  - [ ] Update show.py with --json for applicable commands
  - [ ] Write unit tests for each command
  - [ ] Write integration test for agent workflow
  - [ ] Run full test suite (pytest)
  - [ ] Run linters (ruff, pylint)
  - [ ] Resolve ISSUE-007
- [ ] Verification gates passed
  - [ ] VT-CLI-JSON-001 passing
  - [ ] VT-CLI-JSON-002 passing
  - [ ] VT-CLI-JSON-003 passing

## 10. Notes / Links

**Reference Implementation**:
- `supekku/cli/create.py` lines 58-79 (existing --json pattern for create spec)

**Standard Library Usage**:
- `json.dumps(result, indent=2)` for serialization
- `typer.Option("--json", help="Output result as JSON")` for flag definition

**Testing Commands**:
```bash
# Manual verification after implementation
uv run spec-driver create issue "Test" --json
uv run spec-driver list specs --json
uv run spec-driver show spec SPEC-001 --json

# Automated verification
uv run pytest supekku/cli/ -v
uv run ruff check supekku/cli/
uv run pylint supekku/cli/
```

**Success Criteria**:
- All commands in scope have --json flag
- JSON output matches documented schema
- Default text output unchanged
- All tests passing
- ISSUE-007 closed
