---
id: DE-007
slug: lifecycle-coverage-enforcement
name: Delta - Lifecycle coverage enforcement
created: '2025-11-03'
updated: '2025-11-03'
status: completed
kind: delta
aliases: []
relations: []
tags: ["cli"]
applies_to:
  specs:
    - PROD-008
    - PROD-009
    - SPEC-122
  requirements:
    - PROD-008.FR-001
    - PROD-008.FR-002
    - PROD-008.FR-003
    - PROD-009.FR-002
    - PROD-009.FR-003
---

# DE-007 – Lifecycle coverage enforcement

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-007
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - PROD-008
    - PROD-009
    - SPEC-122
  collaborators: []
requirements:
  implements:
    - PROD-008.FR-001
    - PROD-008.FR-002
    - PROD-008.FR-003
    - PROD-009.FR-002
    - PROD-009.FR-003
  updates: []
  verifies: []
phases:
  - id: IP-007.PHASE-01
    goal: >-
      Wire verification coverage metadata into requirement lifecycle updates
      and enforce coverage hand-back in the delta completion workflow.
    status: planned
```

- **Product Spec(s)**: [PROD-008](../../specify/product/PROD-008/PROD-008.md) – Establishes the coverage contract; [PROD-009](../../specify/product/PROD-009/PROD-009.md) – Defines lifecycle semantics and overlay precedence.
- **Technical Spec(s)**: [SPEC-122](../../specify/tech/SPEC-122/SPEC-122.md) – Describes the requirements registry and lifecycle tracking infrastructure that will consume coverage data.
- **Implementation Plan**: [IP-007](./IP-007.md) – Tracks parser integration, registry changes, and CLI enforcement tasks.
- **Change Drivers**: ISSUE-412 (missed spec coverage updates during delta closure), ISSUE-413 (registry unaware of coverage blocks), PROB-128 (audit drift unresolved).

## 2. Motivation
- Requirements currently drift because the registry ignores coverage blocks and the delta completion flow does not enforce coverage hand-back. This delta operationalises PROD-008 by wiring coverage entries into lifecycle updates and preventing deltas from closing without documented evidence.
- AUD-021 highlighted multiple “verified” requirements whose coverage blocks were stale, prompting stakeholders to request an automated solution.

## 3. Scope & Objectives
- **Primary Outcomes**:
  - Map `supekku:verification.coverage@v1` entries into requirements registry lifecycle states (PROD-008.FR-001).
  - Enforce coverage updates in `spec-driver complete delta`, blocking completion until specs reflect final verification status (PROD-008.FR-002, PROD-008.FR-003).
- **Operational Constraints**: Maintain compatibility for repositories yet to adopt coverage blocks; provide a logged `--force` escape hatch for emergencies.
- **Dependencies**: Relies on SPEC-122 registry infrastructure and product guidance from PROD-008/PROD-009; coordinate rollout with validation tooling owners.

## 4. Out of Scope
- Auto-generating spec coverage entries from audit data (tracked by ISSUE-414).
- Broader frontmatter metadata migration (Phase 6 plan).

## 5. Approach Overview
- **System Touchpoints**:
  - `supekku/scripts/lib/blocks/verification.py` (parser/validator reuse).
  - `supekku/scripts/lib/requirements/registry.py` (lifecycle computation).
  - `supekku/scripts/complete_delta.py` and `supekku/cli/complete.py` (CLI enforcement).
- **Key Changes**:
  - Aggregate coverage entries during registry sync, updating `RequirementRecord` lifecycle fields and surfacing drift warnings when spec vs audit or plan disagree.
  - Enhance delta completion workflow to inspect coverage entries for touched requirements, blocking completion when statuses remain `planned`/missing and providing remediation guidance.
- **Migration / Rollout Notes**: Introduce environment flag `SPEC_DRIVER_ENFORCE_COVERAGE` defaulting to enabled; document override flow in `.spec-driver/RUN.md`.

## 6. Verification Strategy
- **Requirements Coverage**:
  - PROD-008.FR-001 → VT-902 integration test ensuring registry transitions lifecycle when coverage status flips.
  - PROD-008.FR-002 → VA-320 guided completion run demonstrating enforcement messaging and success after coverage update.
  - PROD-008.FR-003 → VH-201 manual validation verifying validator warnings during drift scenarios.
- **Planned Artefacts**: Captured in IP-007 coverage block (VT-902, VA-320, VH-201).
- **Acceptance Criteria**: `just validate-workspace` passes with coverage-fed lifecycle; attempting to complete a sample delta without coverage yields actionable error; audit import surfaces warning that clears once spec updated.

## 7. Risks & Mitigations
- **Risk**: Enforcement blocks emergency fixes – *Likelihood*: medium – *Impact*: medium – *Mitigation*: Allow `--force` override with logging and follow-up backlog entry.
- **Risk**: False positives for specs lacking coverage blocks – *Likelihood*: low – *Impact*: medium – *Mitigation*: Gracefully warn and skip enforcement when no coverage entries exist, nudging owners to adopt blocks.
- **Risk**: Registry regressions affecting unrelated specs – *Likelihood*: low – *Impact*: high – *Mitigation*: Add regression fixtures and run sync against sample corpus before enabling flag.

## 8. Follow-ups & Tracking
- **Future Phases / Deltas**: Automation to compare plan vs spec coverage (ISSUE-413); audit-driven spec suggestions (PROB-128).
- **Backlog Items**: ISSUE-412, ISSUE-413, PROB-128 (this delta closes them or establishes automation follow-up).
- **Open Decisions / Questions**: Should enforcement apply to legacy deltas retroactively? *(Owner: lifecycle-team, Due: 2025-11-07)*

## 9. Implementation Notes
- Coordinate with validation team for registry test fixtures (`tests/fixtures/requirements`).
- Update CLAUDE command playbooks and `.spec-driver/RUN.md` with the enforced completion workflow.
- Run `uv run spec-driver schema show verification.coverage` to refresh docs consumed by agents.

> Replace placeholders with concrete details. Remove sections that do not apply rather than leaving empty headings.