---
id: IP-007
slug: lifecycle-coverage-enforcement
name: Implementation Plan - Lifecycle coverage enforcement
created: '2025-11-03'
updated: '2025-11-03'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-007
delta: DE-007
revision_links:
  aligns_with: []
specs:
  primary:
    - PROD-008
    - PROD-009
    - SPEC-122
  collaborators: []
requirements:
  targets:
    - PROD-008.FR-001
    - PROD-008.FR-002
    - PROD-008.FR-003
    - PROD-009.FR-002
    - PROD-009.FR-003
  dependencies: []
phases:
  - id: IP-007.PHASE-01
  - id: IP-007.PHASE-02```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-007
entries:
  - artefact: VT-902
    kind: VT
    requirement: PROD-008.FR-001
    phase: IP-007.PHASE-01
    status: planned
    notes: Registry sync integration test verifying lifecycle updates.
  - artefact: VA-320
    kind: VA
    requirement: PROD-008.FR-002
    phase: IP-007.PHASE-02
    status: planned
    notes: Guided completion dry run ensuring enforcement messaging.
  - artefact: VH-201
    kind: VH
    requirement: PROD-008.FR-003
    phase: IP-007.PHASE-02
    status: planned
    notes: Manual validation session covering audit drift workflow.
```

## 1. Summary
- **Delta**: DE-007 – Lifecycle coverage enforcement
- **Specs Impacted**: PROD-008 (lifecycle contract), SPEC-122 (requirements & lifecycle engine)
- **Problems / Issues**: ISSUE-412 (coverage hand-back missing), ISSUE-413 (registry unaware of coverage), PROB-128 (audit drift unresolved)
- **Desired Outcome**: Registry lifecycle states reflect coverage blocks and the delta completion CLI enforces coverage updates.

## 2. Context & Constraints
- **Current Behaviour**: Coverage parser exists but registry ignores it; `spec-driver complete delta` allows closure without spec updates; audits reveal unresolved drift.
- **Target Behaviour**: Requirements lifecycle transitions driven by coverage entries (PROD-008.FR-001) and enforced completion flow ensuring hand-back (PROD-008.FR-002/FR-003).
- **Dependencies**: Coordination with validation team; ensure requirements registry tests updated; no external releases blocking.
- **Constraints**: Must maintain compatibility for repositories without coverage blocks; enforcement should be overrideable for emergencies with audit trail.

## 3. Gate Check
- [x] Backlog items linked and prioritised (ISSUE-412, ISSUE-413, PROB-128)
- [x] Spec(s) updated or delta specifies required changes (PROD-008 drafted, SPEC-122 referenced)
- [ ] Test strategy identified (document below and confirm fixtures)
- [ ] Workspace/config changes assessed (flag default + RUN.md update)


> Tip: Plan phases up front, then create the phase sheet for the current phase only. Update later phases when you are ready to execute them.

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Coverage registry integration | Coverage entries drive lifecycle updates and drift warnings | SPEC-122 reviewed, fixtures identified | VT-902 passing, validation warning emitted for simulated drift | `phases/phase-01.md` |
| Phase 02 - Completion workflow enforcement | CLI blocks completion without coverage and docs updated | Phase 01 exit criteria met | VA-320 & VH-201 complete, docs merged, flag defaulted on | _TBD_ |

*Adjust/add phases as needed; every phase must have clear gates. Phase sheets are authored one at a time using `supekku/templates/phase-sheet-template.md`.*

## 5. Phase Detail Snapshot
- **Research Notes**: `DE-007/notes.md` (Phase 0 output)
- **Design Revision**: `DE-007/DR-XXX.md`
- **Active Phase Sheet**: <link once created>
- **Parallelisable Work**: Flag tasks with `[P]` inside phase sheets
- **Plan Updates**: Update this plan when phase outcomes change (new risks, scope adjustments)

## 6. Testing & Verification Plan
- **Updated Suites**: `tests/scripts/lib/requirements/test_registry.py` (add coverage-driven lifecycle cases); `tests/scripts/complete_delta_test.py` (enforcement scenarios); `tests/cli/test_cli.py` (CLI integration).
- **New Cases**: Simulate spec with coverage statuses transitioning planned → verified; attempt delta completion without coverage update; audit drift generating warning cleared after spec fix.
- **Tooling/Fixtures**: Add coverage-enabled fixture spec/delta pairs under `tests/fixtures/requirements/`; extend CLI harness with temp spec coverage updates.
- **Rollback Plan**: Feature flag `SPEC_DRIVER_ENFORCE_COVERAGE` can be disabled to revert to current behaviour while investigation continues.
- **Verification Coverage**: Cross-check `supekku:verification.coverage@v1` entries (VT-902, VA-320, VH-201) against phase tasks before closing delta.

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Enforcement blocks emergency fix | Provide `--force` override, log usage, create follow-up issue | lifecycle-team |
| Coverage absent in legacy specs | Gracefully warn and skip enforcement, document adoption path | validation-team |
| Registry regression | Add regression fixtures + run sync in CI before release | automation |

## 8. Open Questions & Decisions
- [ ] Should enforcement log telemetry for product analytics? (Owner: platform, Due: 2025-11-07)
- [ ] Confirm default state of feature flag with release managers.

## 9. Progress Tracking
- [x] Phase 0 complete
- [x] Phase 1 complete (2025-11-03)
- [x] Phase 2 implementation complete (2025-11-03) - manual validation pending
- [ ] Verification gates passed (VA-320, VH-201 pending)

**Phase 1 Summary (2025-11-03):**
- Registry coverage integration complete
- VT-902 passing
- Zero regressions (11/11 tests)
- Full lint compliance
- See `phases/phase-01.md` section 12 for details

**Phase 2 Summary (2025-11-03):**
- Coverage enforcement in completion workflow implemented
- 19 new tests, all passing, zero regressions (55 total tests)
- RUN.md operational guide created
- AGENTS.md checklist updated
- Full lint compliance (9.96/10, no new issues)
- Manual validation (VA-320, VH-201) pending
- See `phases/phase-02.md` section 12 for details

## 10. Notes / Links
- Audit reference: AUD-021 (drift report prompting this work)
- Supporting docs: PROD-008 spec, SPEC-122 validation spec, coverage schema docs (`uv run spec-driver schema show verification.coverage`).
```
