---
id: DE-008
slug: add-coverage-evidence
name: Separate coverage evidence from audit verification
created: '2025-11-03'
updated: '2025-11-03'
status: completed
kind: delta
aliases: []
tags: ["schema"]
relations:
  - type: addresses
    target: ISSUE-012
    description: Separates coverage artifacts from verified_by field
applies_to:
  specs:
    - SPEC-122
    - SPEC-125
  requirements: []
---

# DE-008 – Separate coverage evidence from audit verification

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-008
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - SPEC-122
  collaborators:
    - SPEC-125
requirements:
  implements: []
  updates: []
  verifies: []
phases: []
```

## 1. Summary & Context
- **Product Spec(s)**: [PROD-008](../../specify/product/PROD-008/) – Requirements Lifecycle Coherence, [PROD-009](../../specify/product/PROD-009/) – Requirement Lifecycle Semantics
- **Technical Spec(s)**: [SPEC-122](../../specify/tech/SPEC-122/) – supekku/scripts/lib/requirements, [SPEC-125](../../specify/tech/SPEC-125/) – supekku/scripts/lib/validation
- **Implementation Plan**: [IP-008](./IP-008.md) – Phase 01 complete (2025-11-03), Phase 02 pending
- **Change Drivers**: [ISSUE-012](../../backlog/issues/ISSUE-012-capture-coverage-artefacts-separately-from-verified-by/) – Validator errors due to mixed artifact types in verified_by field

## 2. Motivation

The current requirements registry conflates two distinct concepts:
1. **Coverage evidence**: VT/VA/VH artifacts demonstrating that implementation satisfies requirements (from delta plans, specs)
2. **Audit verification**: Formal audit records (AUD-XXX) attesting requirement compliance

This conflation causes hard validation errors because `WorkspaceValidator` expects `verified_by` to contain only audit IDs, but coverage sync populates it with VT/VA/VH artifact IDs. The mixed semantics also obscure provenance – we cannot distinguish "verified by audit AUD-003" from "covered by test VT-902 in delta DE-007."

**Target state**: Clear separation where `verified_by` holds audit IDs and `coverage_evidence` holds VT/VA/VH artifact IDs, enabling accurate validation and transparent provenance tracking.

## 3. Scope & Objectives

**Primary Outcomes**:
- Add `coverage_evidence` field to `RequirementRecord` dataclass for VT/VA/VH artifact IDs
- Restore `verified_by` to audit-only semantics, eliminating validator conflicts
- Update registry sync logic to populate `coverage_evidence` instead of `verified_by` for VT/VA/VH artifacts
- Implement validation warnings for coverage evidence without baseline status or missing audits after grace period
- Update CLI/JSON output to surface both coverage evidence and audit verification separately

**Operational Constraints**:
- Clean break: no backward compatibility required (pre-1.0)
- Manual cleanup of existing mixed data acceptable
- Must not break existing delta completion workflow

**Dependencies**: None blocking, but relates to PROD-008/PROD-009 lifecycle semantics work

## 4. Out of Scope

- Automatic migration script for existing registries (manual cleanup acceptable)
- Richer metadata structure for coverage_evidence (keep simple list matching verified_by pattern)
- Historical provenance tracking beyond current state

## 5. Approach Overview

**System Touchpoints**:
- `supekku/scripts/lib/requirements/registry.py`: RequirementRecord dataclass, sync logic
- `supekku/scripts/lib/validation/validator.py`: WorkspaceValidator checks
- `supekku/scripts/lib/formatters/requirement_formatters.py`: Display logic
- `supekku/scripts/requirements.py`: CLI output
- `.spec-driver/registry/requirements.yaml`: Schema structure
- `supekku/about/glossary.md`: Documentation updates

**Key Changes**:
1. **Schema Change** (SPEC-122):
   - Add `coverage_evidence: list[str]` field to RequirementRecord
   - Update `to_dict()` and `from_dict()` methods
   - Update YAML serialization/deserialization

2. **Sync Logic** (SPEC-122):
   - Modify `_apply_coverage_evidence()` to populate `coverage_evidence` instead of `verified_by`
   - Keep audit-related sync logic targeting `verified_by` unchanged

3. **Validation** (SPEC-125):
   - Remove false-positive errors where VT/VA/VH in `verified_by` triggered audit validation failures
   - Add warning: coverage evidence exists but requirement status not baseline/active/verified
   - Add warning: no audit verification after configured grace period (reference PROD-009 for period definition)

4. **Display** (SPEC-120):
   - Update `format_requirement_detail()` to show both `verified_by` (audits) and `coverage_evidence` (VT/VA/VH) separately
   - Update JSON output schema to include both fields

**Migration Notes**:
- No automatic migration provided (clean break)
- Operators should run `just supekku::sync-all` after deployment to repopulate coverage_evidence from coverage blocks
- Existing `verified_by` entries with VT/VA/VH IDs will need manual cleanup if desired (not required for correctness)

## 6. Verification Strategy

**Requirements Coverage**: TBD pending spec updates

**Planned Artefacts**:
- VT-XXX: Unit tests for RequirementRecord serialization with coverage_evidence
- VT-XXX: Unit tests for sync logic populating coverage_evidence
- VT-XXX: Unit tests for validation warnings (coverage without baseline, missing audits)
- VT-XXX: Integration tests for complete delta workflow with coverage checking
- VA-XXX: Agent verification of validator error elimination
- VH-XXX: Manual verification of CLI output displaying both fields correctly

**Acceptance Criteria**:
1. `WorkspaceValidator.validate()` produces zero errors related to VT/VA/VH in verified_by
2. Coverage sync populates `coverage_evidence`, not `verified_by`
3. Validation warnings trigger for coverage evidence edge cases per PROD-009
4. CLI output clearly distinguishes audit verification from test coverage
5. Delta completion workflow (including `check_coverage_completeness`) continues working
6. All tests pass, linters clean

## 7. Risks & Mitigations

- **Risk**: Existing deltas with VT/VA/VH in verified_by may break completion checks – *Likelihood*: medium – *Impact*: medium – *Mitigation*: Update `check_coverage_completeness()` to look at coverage blocks in specs, not registry verified_by field (already implemented correctly in coverage_check.py)

- **Risk**: Manual cleanup burden for existing registries – *Likelihood*: high – *Impact*: low – *Mitigation*: Document cleanup procedure; sync automatically repopulates correct field going forward

- **Risk**: Validation warning thresholds unclear without PROD-009 grace period definition – *Likelihood*: medium – *Impact*: low – *Mitigation*: Use reasonable default (e.g., 30 days) or make configurable; document in code comments

## 8. Follow-ups & Tracking

**Future Phases / Deltas**:
- Potential future enhancement: richer metadata structure (timestamp, source file) for coverage_evidence if provenance tracking needs increase

**Backlog Items**:
- [ISSUE-012](../../backlog/issues/ISSUE-012-capture-coverage-artefacts-separately-from-verified-by/) – Addressed by this delta

**Open Decisions / Questions**:
- Grace period duration for audit verification warnings (coordinate with PROD-009 implementation)

## 9. Implementation Notes

**Key Files**:
- `supekku/scripts/lib/requirements/registry.py:50-95` – RequirementRecord dataclass
- `supekku/scripts/lib/requirements/registry.py:608-619` – Coverage sync logic
- `supekku/scripts/lib/validation/validator.py:61-66` – Audit verification checks
- `supekku/scripts/lib/formatters/requirement_formatters.py` – Display formatting

**Testing Commands**:
- `just test` – Run all tests
- `just lint` – Ruff linting
- `just pylint` – Pylint checks
- `uv run spec-driver complete delta DE-XXX` – Integration test delta completion

**Documentation Updates Required**:
- `supekku/about/glossary.md` – Update RequirementRecord entry
- Relevant SPEC frontmatter/Section 3 responsibilities
- Coverage block examples in spec templates