---
id: IP-008
slug: add-coverage-evidence
name: Implementation Plan - Separate coverage evidence from audit verification
created: '2025-11-03'
updated: '2025-11-03'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-008
delta: DE-008
revision_links:
  aligns_with: []
specs:
  primary:
  - SPEC-122
  collaborators:
  - SPEC-125
  - SPEC-120
requirements:
  targets: []
  dependencies: []
phases:
- id: IP-008.PHASE-01
  name: Phase 01 - Schema & sync foundation
  objective: Add coverage_evidence field to RequirementRecord and update sync logic
    to populate it instead of verified_by for VT/VA/VH artifacts.
  entrance_criteria:
  - SPEC-122 guidance reviewed
  - Test fixtures identified
  exit_criteria:
  - RequirementRecord serialization includes coverage_evidence
  - Coverage sync populates coverage_evidence, not verified_by
  - Unit tests passing for schema and sync
  - Zero regressions
- id: IP-008.PHASE-02
  name: Phase 02 - Validation & display
  objective: Implement validation warnings for coverage edge cases and update all
    display/formatting to distinguish coverage from audit verification.
  entrance_criteria:
  - Phase 01 exit criteria met
  exit_criteria:
  - Validation warnings trigger for coverage without baseline status
  - Validation warnings trigger for missing audits after grace period
  - CLI/JSON output shows both fields separately
  - All tests passing, linters clean
  - Documentation updated
- id: IP-008.PHASE-02
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-008
entries:
  - artefact: VT-910
    kind: VT
    requirement: TBD
    phase: IP-008.PHASE-01
    status: verified
    notes: RequirementRecord serialization with coverage_evidence field (test_coverage_evidence_field_serialization + test_coverage_evidence_merge)
  - artefact: VT-911
    kind: VT
    requirement: TBD
    phase: IP-008.PHASE-01
    status: verified
    notes: Coverage sync populates coverage_evidence correctly (test_coverage_sync_populates_coverage_evidence + test_sync_processes_coverage_blocks)
  - artefact: VT-912
    kind: VT
    requirement: TBD
    phase: IP-008.PHASE-02
    status: planned
    notes: Validation warnings for coverage without baseline status
  - artefact: VT-913
    kind: VT
    requirement: TBD
    phase: IP-008.PHASE-02
    status: planned
    notes: Validation warnings for missing audits after grace period
  - artefact: VT-914
    kind: VT
    requirement: TBD
    phase: IP-008.PHASE-02
    status: planned
    notes: Integration test for complete sync workflow
  - artefact: VA-321
    kind: VA
    requirement: TBD
    phase: IP-008.PHASE-02
    status: planned
    notes: Agent verification of validator error elimination
  - artefact: VH-202
    kind: VH
    requirement: TBD
    phase: IP-008.PHASE-02
    status: planned
    notes: Manual CLI output verification
```

## 1. Summary
- **Delta**: DE-008 – Separate coverage evidence from audit verification
- **Specs Impacted**: SPEC-122 (requirements registry), SPEC-125 (validation), SPEC-120 (formatters)
- **Problems / Issues**: ISSUE-012 (validator errors from mixed artifact types)
- **Desired Outcome**: Requirements registry with separate coverage_evidence field eliminating validator false positives and enabling clear provenance tracking

## 2. Context & Constraints
- **Current Behaviour**: Coverage sync pushes VT/VA/VH into verified_by field; WorkspaceValidator expects only AUD-XXX, emitting hard errors
- **Target Behaviour**: coverage_evidence holds VT/VA/VH artifacts; verified_by holds only audit IDs; validation warnings for coverage edge cases per PROD-009
- **Dependencies**: None blocking; relates to PROD-008/PROD-009 lifecycle semantics
- **Constraints**: Clean break (no backward compatibility); manual cleanup acceptable; must not break delta completion workflow

## 3. Gate Check
- [x] Backlog items linked and prioritised (ISSUE-012)
- [x] Spec(s) updated or delta specifies required changes (SPEC-122, SPEC-125 to be updated during closeout)
- [x] Test strategy identified (unit + integration + manual verification)
- [x] Workspace/config changes assessed (registry schema change, no config needed)

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Schema & sync foundation | Add coverage_evidence field and update sync logic | SPEC-122 reviewed, fixtures identified | Schema serialization working, sync populating coverage_evidence, unit tests passing | `phases/phase-01.md` |
| Phase 02 - Validation & display | Validation warnings and display updates | Phase 01 exit criteria met | Warnings triggering correctly, CLI output updated, all tests passing, docs updated | `phases/phase-02.md` |

## 5. Phase Detail Snapshot
- **Research Notes**: `DE-008/IP-008-PLAN.md` (implementation analysis)
- **Design Revision**: Not required (straightforward schema addition)
- **Active Phase Sheet**: `phases/phase-01.md` (to be created)
- **Parallelisable Work**: Phase 02 validation and display work can be parallelized once phase 01 complete
- **Plan Updates**: Update verification block requirement IDs once specs updated

## 6. Testing & Verification Plan
- **Updated Suites**:
  - `supekku/scripts/lib/requirements/registry_test.py` – Add coverage_evidence serialization and sync tests
  - `supekku/scripts/lib/validation/validator_test.py` – Add validation warning tests
  - `supekku/scripts/lib/formatters/requirement_formatters_test.py` – Add display tests
- **New Cases**:
  - RequirementRecord with coverage_evidence serializes/deserializes correctly
  - Coverage sync from IP/spec/delta/audit populates coverage_evidence
  - Validation warning when coverage_evidence exists but status is pending/retired
  - Validation warning when no audit exists 30+ days after introduced
  - JSON output includes both verified_by and coverage_evidence
- **Tooling/Fixtures**: Extend existing test fixtures with coverage_evidence examples
- **Rollback Plan**: Not applicable (clean break)
- **Verification Coverage**: Cross-check VT-910 through VH-202 against phase tasks

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Existing registry has mixed verified_by entries | Document cleanup; sync repopulates correctly | dev |
| Grace period duration undefined | Use 30-day default, make configurable constant | dev |
| Delta completion breaks | Verify check_coverage_completeness uses blocks not registry | dev |

## 8. Open Questions & Decisions
- [x] Coverage_evidence structure: simple list (decided)
- [x] Backward compatibility: clean break (decided)
- [ ] Grace period for audit warnings: 30 days default (to confirm with PROD-009)
- [ ] Should we add a migration helper script? (deferred - manual cleanup acceptable)

## 9. Progress Tracking
- [x] Phase 01 complete (2025-11-03)
- [x] Phase 02 substantially complete (2025-11-03)
- [ ] Verification gates passed (VH-202, VA-321 pending)

**Phase 01 Summary** (2025-11-03):
- Schema changes complete: coverage_evidence field added
- Sync logic updated: populates coverage_evidence not verified_by
- Tests complete: VT-910, VT-911 verified
- All tests passing (1166 total)
- Lint clean (ruff + pylint 9.60+/10)
- Commit: 94dcbaa
- See: `phases/phase-01.md` for details

**Phase 02 Summary** (2025-11-03):
- Validation warnings: coverage without baseline status (VT-912)
- Formatters updated: details + JSON display coverage_evidence
- Tests complete: 3 new tests (1169 total)
- Lint clean (ruff + pylint 9.74/10)
- Deferred: grace period audit warnings (TODO), VT-914 (covered by existing tests)
- Ready for: manual CLI verification (VH-202), agent verification (VA-321)
- See: `phases/phase-02.md` for details

## 10. Notes / Links
- Implementation analysis: `IP-008-PLAN.md`
- Key files:
  - `supekku/scripts/lib/requirements/registry.py:50-112` (RequirementRecord)
  - `supekku/scripts/lib/requirements/registry.py:520-619` (sync logic)
  - `supekku/scripts/lib/validation/validator.py:61-66` (validation)
- Related: PROD-008, PROD-009 lifecycle semantics
