---
id: IP-009
slug: cli-json-consistency-fixes
name: Implementation Plan - CLI JSON consistency fixes
created: '2025-11-03'
updated: '2025-01-04'
status: completed
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-009
delta: DE-009
revision_links:
  aligns_with: []
specs:
  primary:
    - SPEC-110
  collaborators:
    - SPEC-120
requirements:
  targets:
    - PROD-010.FR-001
    - PROD-010.FR-002
    - PROD-010.FR-003
    - PROD-010.NF-003
  dependencies: []
phases:
  - id: IP-009.PHASE-01
  - id: IP-009.PHASE-02
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-009
entries:
  - artefact: VT-PROD010-JSON-001
    kind: VT
    requirement: PROD-010.FR-001
    phase: IP-009.PHASE-01
    status: verified
    notes: Unit tests verify --json flag on all list commands produces valid parseable JSON matching --format=json output. Tests in supekku/cli/test_cli.py::TestJSONFlagConsistency.
  - artefact: VT-PROD010-JSON-002
    kind: VT
    requirement: PROD-010.FR-002
    phase: IP-009.PHASE-02
    status: verified
    notes: Completed in Phase 02. Added Spec.to_dict() method. Fixed all show commands to properly call to_dict(root). All show commands return complete structured JSON. 92/92 tests passing.
  - artefact: VT-PROD010-FILTER-001
    kind: VT
    requirement: PROD-010.FR-003
    phase: IP-009.PHASE-01
    status: verified
    notes: Unit tests verify -s/--status filter on specs command filters correctly and matches deltas/adrs behavior. Tests in supekku/cli/test_cli.py::TestStatusFilterParity.
  - artefact: VH-PROD010-UX-001
    kind: VH
    requirement: PROD-010.NF-003
    phase: IP-009.PHASE-01
    status: verified
    notes: Manual validation confirmed all Priority 1 findings from UX research addressed. 74/74 CLI tests passing with 35 new tests covering all changes.
```

## Implementation Summary

**Status**: ✅ **COMPLETED** - 2025-01-04

**Delta**: [DE-009](./DE-009.md) - CLI JSON consistency fixes

**Specs Impacted**:
- Primary: [SPEC-110](../../specify/tech/SPEC-110/SPEC-110.md) - supekku/cli
- Collaborators: [SPEC-120](../../specify/tech/SPEC-120/SPEC-120.md) - formatters
- Requirements: [PROD-010](../../specify/product/PROD-010/PROD-010.md) (FR-001, FR-002, FR-003, NF-003)

**Desired Outcome**: Standardize CLI JSON output and status filtering across all commands to enable consistent agent automation patterns without command-specific logic.

**Implementation Approach**: Two-phase TDD implementation following "Skinny CLI" patterns.

**Key Deliverables**:
- `supekku/cli/list.py` - JSON flags + status filter
- `supekku/cli/show.py` - JSON flags for ALL show commands with complete output
- `supekku/scripts/lib/specs/models.py` - Added Spec.to_dict() method
- `supekku/cli/test_cli.py` - Comprehensive test coverage (92 tests passing)

**Phase Execution**:
- [Phase 01](./phases/phase-01.md) - ✅ COMPLETED - List commands and partial show support
- [Phase 02](./phases/phase-02.md) - ✅ COMPLETED - Complete show command JSON serialization

**Verification**: All requirements verified
- FR-001 (list commands) - ✅ Verified
- FR-002 (show commands) - ✅ Verified (Phase 02 fixed spec/adr/policy/standard)
- FR-003 (status filter) - ✅ Verified
- NF-003 (UX research) - ✅ Verified

**References**:
- UX Research: `docs/ux-research-cli-2025-11-03.md`
- Phase Sheet: `phases/phase-01.md` (detailed execution notes)
- Architectural patterns: `CLAUDE.md` (Skinny CLI, formatter separation)
```
